\name{resolveEdges.ggobi}
\alias{resolveEdges.ggobi}
\title{Resolve symbolic edges relative to dataset}
\description{
  In GGobi, we can represent edges symbolically using
  the identifiers for the pair of nodes. When we use
  these edges with a particular dataset, we must
  map these symbolic descriptions to particular
  records in the nodeset by using indices.
  Thus we must map the symbolic names to indices of records
  in datasets. This is done automatically
  for us in GGobi and this function provides a mechanism
  for doing it in R using simple matching of names.
  The resulting resolved edges could be handed to GGobi if necessary.
}
\usage{
resolveEdges.ggobi(symbolic, dataset)
}
\arguments{
  \item{symbolic}{the symbolic description of the edges in terms of the
    names/identifiers of the pair of nodes.
    This should be an k by 2 data frame or matrix with each record/row
    giving the source and destination by  name}
  \item{dataset}{the dataset in which to lookup the node
    identifiers and find the node indices.}
}

\value{
  An n by 2 matrix giving the source and destination node indices
  for each 
}
\references{\url{http://www.ggobi.org/RSggobi.html}}
\author{Duncan Temple Lang}
\note{It is not clear that we ever need this since GGobi does it
  for us, but it is useful to illustrate how it is done
  and also we currently do not provide access to the internally resolved
  edge sets.}
\seealso{
 \code{\link{createEdgeDataset.ggobi}}
}
\examples{
 data(mtcars)
 pairs = matrix(c("Mazda RX4", "Merc230",
                  "Maserati Bora", "Ferrari Dino"),
                  , 2, byrow = TRUE)
 resolveEdges.ggobi(pairs, mtcars)
}
\keyword{manip}

