getColorSchemes <-
function(.gobi = NULL)  
{
 .GGobiCall("getColorSchemes", .gobi = .gobi)
}  


addColorScheme <-
function(scheme, name, overwrite = FALSE, set = FALSE, .gobi = NULL)  
{
    # compute the type based on the class.
  type <- as.integer(0)
  if(missing(name))
    name = scheme@name
  
  ans <- .GGobiCall("addColorScheme", scheme, as.character(name), as.logical(overwrite), .gobi = .gobi)

  if(set)
    setActiveColorScheme(name, .gobi = .gobi)

  ans
}  

setActiveColorScheme <-
function(id, .gobi = NULL)
{
  if(is.numeric(id))
    id <- as.integer(id)
  
 .GGobiCall("setActiveColorScheme", id, .gobi = .gobi)
}

getActiveColorScheme =
function(.gobi = NULL)
{
  .GGobiCall("getActiveColorScheme", .gobi = .gobi)
}


resolveColors.ggobi =
function(colNames, scheme = NULL, .gobi = getDefaultGGobi())
{
  if(is.null(scheme) || as.character(scheme) == "")
    scheme = getActiveColorScheme()
  else
    scheme = getColorSchemes()[[as.character(scheme)]]

  
  match(colNames, names(scheme@colors))
}



