\name{setColors.ggobi}
\alias{setColors.ggobi}
\alias{getColors.ggobi}
\alias{setLineSegments.ggobi}
\alias{setHiddenCases.ggobi}
\alias{getLineSegments.ggobi}
\alias{getHiddenCases.ggobi}

\title{Access color and hidden attributes of records.}
\description{
}
\usage{
setColors.ggobi(colors, which = 1:length(colors), .data=1, .gobi=getDefaultGGobi())
getColors.ggobi(which, .data=1, .gobi=getDefaultGGobi())
setHiddenCases.ggobi(vals, which = 1:length(vals), .data = 1, .gobi=getDefaultGGobi())
getHiddenCases.ggobi(.data = 1, .gobi=getDefaultGGobi())
}
\arguments{
  \item{colors}{color identifiers, either indices into the color map,
   or names of entries in the color map.}
  \item{vals}{logical vector giving the settings for the records
   identified in the parallel vector of indices \code{which}.}
  \item{which}{the indices of the records for which the color
  should be set. This vector is used in parallel with the \code{colors}
  argument. The i-th element of colors is applied to the record
  identified by the i-the element of \code{which}.}
  \item{.data}{the identifier for the dataset whose records are to be 
  set or queried. This can be an integer, name/string or an object of
  class \code{ggobiDataset}.} 
  \item{.gobi}{the ggobi instance identifier. This is used to resolve the
  dataset and is unecessary if an object of class  \code{ggobiDataset} is 
  supplied for the \code{.data} argument.}
}
\value{

}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}

\seealso{
\code{\link{getGlyphs.ggobi}}
}

\examples{
  g <- ggobi(system.file("data", "flea.xml", package="Rggobi"), args="-noinit")
  g$getColors()
  g$setColors(rep(2, 74), which=1:nrow(g[[1]]))

   # now highlight a subset of the points
  g$setColors(rep(1, 74), which=1:32)

\dontrun{
# Update
   # Set the first 30 records to blue.
  g$setColors(rep("blue",30))  # no colornames for the moment

   # Set the colormap and then set the 
   # points.
  m <- g$getColorMap()
  m["green", 1] <- .5
  g$setColorMap(m)
  g$setColors(rep("green",30))
}
}
\keyword{iplot}
\keyword{dynamic}
