\name{getPlotWidgets.ggobiDisplay}
\alias{getPlotWidgets.ggobiDisplay}
\title{Retrieve GtkWidget objects for plots in GGobi display}
\description{
  This retrieves the GtkWidget objects corresponding to the
  individual plots within a GGobi display and make them available
  for direct use within R.
  One can then add callabacks to individual widgets, reparent a widget,
  draw on the widget, etc. and generally manipulate using
  functions from the \code{RGtk} package.
}
\usage{
getPlotWidgets.ggobiDisplay(dpy, expandClasses = TRUE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{dpy}{the GGobi display in which to find the plot widgets.
    This should be an object of class \code{ggobiDisplay}.}
  \item{expandClasses}{a logical value indicating whether to compute the
    actual class of the widgets or whether to return them as generic
    GtkObjects.}
}

\value{
  A list with as many elements as there are splotd elements
  within the GGobi display.  Each element is a GtkObject.
}

\seealso{
 \code{\link{getDisplays.ggobi}}
}
\examples{
 data(mtcars)
 ggobi(mtcars)
 dpy = parcoords.ggobi(1:4)
 getPlotWidgets.ggobiDisplay(dpy)
}
\keyword{iplot}
\keyword{dynamic}


