/*
 * robsupervis.h
 * 
 * Copyright (c) 2000-2004 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

/** @file
  * Declares the default concrete SimSupervisor classes. 
  */

#ifndef __RT_SUPERVISORS__
#define __RT_SUPERVISORS__

#include "robbase.h"

#include <rtstring.h>

using namespace lrt;

namespace rt {

/** Creates a robot for each Program at the beginning of the Simulation. */
class StdBotCreator : public SimSupervisor {

public:
	StdBotCreator();
	virtual ~StdBotCreator();

	virtual SimSuperPosition getPreferredPosition();
	virtual unsigned long getStepCycles();
	virtual void initSim(Simulation* const sim);
	virtual GameState exec(Simulation* const sim);

private:
	GameState retState;
};

/** Checks if the Simulation is finished using default rules. */
class StdVictorySupervisor : public SimSupervisor {

public:
	StdVictorySupervisor();
	virtual ~StdVictorySupervisor();

	virtual SimSuperPosition getPreferredPosition();
	virtual unsigned long getStepCycles();
	virtual void initSim(Simulation* const sim);
	virtual GameState exec(Simulation* const sim);

private:
	GameState retState;
};




} // namespace

#endif
