/*
 * rtsound.win32.cpp
 * 
 * Copyright (c) 2000-2005 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

#ifndef __LRT_SOUND_WIN32__
#define __LRT_SOUND_WIN32__

#include "rtsound.h"
#include "rtstring.h"
#include "rtfile.h"
#include <windows.h>

namespace lrt {

bool Sound::isSupported()
{
	return true;
}

String Sound::getExtension()
{
	return ".wav";
}

bool Sound::play(const String& logicalSoundName, bool sync, bool stop)
{
	String soundfile = resolve(logicalSoundName);
	if(soundfile == String()) return false;
	long flags = SND_FILENAME;
	flags |= (sync ? SND_SYNC : SND_ASYNC);
	if(!stop) flags |= SND_NOSTOP;
	return (PlaySound(soundfile.cStr(), 0, flags) != 0);
}



} // namespace

#endif

