#include "rpggame.h"

namespace game
{
	VARP(debug, 0, 0, DEBUG_MAX);
	rpgchar *player1 = new rpgchar();

	// GAME DEFINITIONS
	vector<script *> scripts; ///scripts, includes dialogue
	vector<effect *> effects; ///pretty particle effects for spells and stuff
	vector<statusgroup *> statuses; ///TODO find a better name - status effect definitions to transfer onto victims
	vector<item_base *> items;
	vector<ammotype *> ammotypes;
	vector<char_base *> chars;
	vector<faction *> factions;
	vector<object_base *> objects;
	vector<mapscript *> mapscripts;
	vector<recipe *> recipes;

	vector<int> variables; //global variables
	vector<const char *> tips;

	hashtable<const char *, mapinfo> *mapdata = NULL;
	mapinfo *curmap = NULL;
	bool connected = false;
	bool transfer = false;

	ICOMMAND(primaryattack, "D", (int *down),
		player1->primary = *down != 0 && ! player1->secondary;
	)

	ICOMMAND(secondaryattack, "D", (int *down),
		player1->secondary = *down != 0 && ! player1->primary;
	)

	ICOMMAND(hotkey, "i", (int *n),
		if(rpggui::open())
			rpggui::hotkey(*n);
		/*
		else
			-equip hot keyed items
		*/
	)

	void cleangame()
	{
		rpgscript::clean();

		if(mapdata)
		{
			if(DEBUG_WORLD)
				conoutf(CON_DEBUG, "DEBUG: clearing map data: %p %p", mapdata, curmap);

			if(curmap)
				curmap->objs.removeobj(player1);

			delete mapdata; mapdata = NULL;
			curmap = NULL;
		}

		if(DEBUG_WORLD)
			conoutf(CON_DEBUG, "DEBUG: clearing %i scripts, %i effects, %i status effects, %i items, %i ammotypes, %i characters, %i factions, %i objects, %i mapscripts, %i recipes, %i variables and %i tips",
				scripts.length(), effects.length(), statuses.length(), items.length(), ammotypes.length(), chars.length(), factions.length(), objects.length(), mapscripts.length(), recipes.length(), variables.length(), tips.length());

		scripts.deletecontents();
		effects.deletecontents();
		statuses.deletecontents();
		items.deletecontents();
		ammotypes.deletecontents();
		chars.deletecontents();
		factions.deletecontents();
		objects.deletecontents();
		mapscripts.deletecontents();
		recipes.deletecontents();
		variables.setsize(0);
		tips.deletearrays();
		camera::cleanup(true);

		player1->inventory.deletecontents();
		player1->equipped.setsize(0);
	}

	void newgame(const char *game)
	{
		if(DEBUG_WORLD)
			conoutf(CON_DEBUG, "DEBUG: starting new game");

		cleangame();

		mapdata = new hashtable<const char *, mapinfo>;

		emptymap(0, true, NULL, false);

		defformatstring(file)("data/rpg/games/%s.cfg", game);
		if(DEBUG_WORLD)
			conoutf(CON_DEBUG, "DEBUG: attempting to load game definitions from %s", file);

		if(!execfile(file, false))
		{
			conoutf(CON_ERROR, "ERROR: data for game \"%s\" does not exist, falling back to \"default\"", game);
			if(!execfile("data/rpg/games/default.cfg"))
				fatal("Unable to start game");
		}

		if(chars.inrange(0))
		{
			chars[0]->transfer(*player1);
			player1->resetmdl();
			rpgscript::doentscript(player1, player1, SCR_SPAWN);
		}
		else
		{
			conoutf(CON_ERROR, "ERROR! no character definition for player! continuing with current stats");
		}
	}
	COMMAND(newgame, "s");

	void initclient()
	{
	}

	void spawnplayer(rpgent *d)
	{
		findplayerspawn(d, -1);
	}

	void respawnself(bool death = false)
	{
		player1->respawn();
	}

	void respawn()
	{
		if(player1->state==CS_DEAD)
		{
			respawnself(true);
		}
	}

	struct collision
	{
		rpgent *d, *o;
		vec dir;

		collision(rpgent *de, rpgent *oe, const vec &ddir) : d(de), o(oe), dir(ddir) {}
		static void add(physent *d, physent *o, const vec &dir);
	};
	vector<collision> colcache;

	void collision::add(physent *d, physent *o, const vec &dir)
	{
		loopv(colcache)
		{
			if((colcache[i].d == d && colcache[i].o == o) || (colcache[i].d == o && colcache[i].o == d))
				return;
		}

		colcache.add(collision((rpgent *) d, (rpgent *) o, dir));
		return;
	}

	void dynentcollide(physent *d, physent *o, const vec &dir)
	{
		collision::add(d, o, dir);
	}

	mapinfo *accessmap(const char *name)
	{
		if(!mapdata)
			return NULL;

		mapinfo *dummy = mapdata->access(name);
		if(DEBUG_WORLD)
			conoutf(CON_DEBUG, "DEBUG: finding map data (%p)", dummy);

		if(!dummy)
		{
			const char *newname = newstring(name);
			dummy = &mapdata->access(newname, mapinfo());
			dummy->name = newname;

			if(DEBUG_WORLD)
				conoutf(CON_DEBUG, "DEBUG: map data not found - creating (%p)", dummy);
		}

		return dummy;
	}

	int lasttip = -1;

	void startmap(const char *name)
	{
		entities::genentlist();
		ai::clearwaypoints();
		camera::cleanup();
		if(!name)
			return;

		ai::loadwaypoints(name);

		if(curmap)
		{
			if(DEBUG_WORLD)
				conoutf(CON_DEBUG, "DEBUG: removing player from curmap vector");
			curmap->objs.removeobj(player1);
		}

		curmap = accessmap(name);

		if(DEBUG_WORLD)
			conoutf(CON_DEBUG, "DEBUG: adding player to curmap vector");
		curmap->objs.add(player1);

		if(!curmap->loaded)
		{
			if(DEBUG_WORLD)
				conoutf(CON_DEBUG, "DEBUG: map not loaded - initialising");

			rpgscript::domapscript(curmap, NULL, MSCR_LOAD);
			curmap->loaded = true;
		}

		if(!transfer)
			spawnplayer(player1);

		transfer = false;

		//loop in reverse to not erase new queued actions - ie persistent scripts
		loopvrev(curmap->loadactions)
		{
			curmap->loadactions[i]->exec();
			delete curmap->loadactions[i];
			curmap->loadactions.remove(i);
		}

		if(DEBUG_WORLD)
		{
			enumeratekt(*mapdata, const char *, name, mapinfo, info,
				conoutf(CON_DEBUG, "DEBUG: map %s", name);
				conoutf(CON_DEBUG, "DEBUG: map objects %i", info.objs.length());
				conoutf(CON_DEBUG, "DEBUG: loaded %i", info.loaded);
				conoutf(CON_DEBUG, "DEBUG: deferred actions %i", info.loadactions.length());
			);
		}

		if(tips.inrange(lasttip))
			conoutf("\f2%s", tips[lasttip]);
	}

	void updateworld()
	{
		rpggui::forcegui();
		if(!curtime || !curmap) return;
		physicsframe();

		loopv(curmap->objs)
		{
			rpgent *d = curmap->objs[i];
			float eye = d->eyeheight;

			d->update();
			loopvj(d->seffects)
			{
				if(!d->seffects[j]->update(d))
				{
					delete d->seffects[j];
					d->seffects.remove(j);
					j--;
				}
			}
			if(d->temp.mdl)
				setbbfrommodel(d, d->temp.mdl);

			eye = d->eyeheight - eye;
			if(eye > 0)
			{
				if(DEBUG_ENT)
					conoutf("DEBUG: ent has new eyeheight of %f, applying positional delta of %f", d->eyeheight, eye);
				d->o.z += eye;
				d->newpos.z += eye;
			}
		}

		loopv(colcache)
		{
			//note dir is the direction d is from o based on the collision point

			collision &c = colcache[i];
			rpgscript::doentscript(c.o, c.d, SCR_COLLIDE);
			rpgscript::doentscript(c.d, c.o, SCR_COLLIDE);

			if(c.dir.z > 0)
			{
				rpgobject *o = (rpgobject *) c.o;
				if(o->type() == ENT_OBJECT && o->flags & (rpgobject::MOVABLE|rpgobject::PLATFORM) &&
					(c.d->type() != ENT_OBJECT || ((rpgobject *) c.d)->flags & rpgobject::MOVABLE))
					o->stack.add(c.d);
			}
			else if (c.dir.z < 0)
			{
				rpgobject *d = (rpgobject *) c.d;
				if(d->type() == ENT_OBJECT && d->flags & (rpgobject::MOVABLE|rpgobject::PLATFORM) &&
					(c.o->type() != ENT_OBJECT || ((rpgobject *) c.o)->flags & rpgobject::MOVABLE))
					d->stack.add(c.o);
			}
			else
			{
				rpgchar *pusher = NULL;
				rpgobject *pushee = NULL;

				if(c.o->type() == ENT_CHAR) pusher = (rpgchar *) c.o;
				else if(c.o->type() == ENT_OBJECT) pushee = (rpgobject *) c.o;

				if(c.d->type() == ENT_CHAR) { pusher = (rpgchar *) c.d; c.dir.neg(); }
				else if(c.d->type() == ENT_OBJECT) pushee = (rpgobject *) c.d;

				if(pusher && pushee && pushee->flags & rpgobject::MOVABLE)
					pushee->vel.add(vec(c.dir).mul(pusher->maxspeed * curtime / 500.0f)); // TODO factor strength and weight into this
			}
		}
		colcache.setsize(0);

		ai::trydrop();
		rpgscript::update();

		loopvrev(curmap->projs)
		{
			if(!curmap->projs[i]->update())
			{
				delete curmap->projs[i];
				curmap->projs.remove(i);
			}
		}
		loopvrev(curmap->aeffects)
		{
			if(!curmap->aeffects[i]->update())
			{
				delete curmap->aeffects[i];
				curmap->aeffects.remove(i);
			}
		}

		camera::update();
	}

	void setwindowcaption()
	{
		defformatstring(capt)("Sandbox RPG %s: %s", version, curmap ? curmap->name : "No Map");
		SDL_WM_SetCaption(capt, NULL);
	}

	void preload()
	{
		loopv(effects)
		{
			if(effects[i]->mdl)
			{
				preloadmodel(effects[i]->mdl);
				if(DEBUG_WORLD)
					conoutf(CON_DEBUG, "DEBUG: preloading %s", effects[i]->mdl);
			}
		}
		loopv(chars)
		{
			if(chars[i]->mdl)
			{
				preloadmodel(chars[i]->mdl);
				if(DEBUG_WORLD)
					conoutf(CON_DEBUG, "DEBUG: preloading %s", chars[i]->mdl);
			}
		}
		loopv(items)
		{
			if(items[i]->mdl)
			{
				preloadmodel(items[i]->mdl);
				if(DEBUG_WORLD)
					conoutf(CON_DEBUG, "DEBUG: preloading %s", items[i]->mdl);
			}
		}
		loopv(statuses)
		{
			loopvj(statuses[i]->effects)
			{
				status_polymorph *p = (status_polymorph *) statuses[i]->effects[j];
				if(p->type == STATUS_POLYMORPH)
				{
					preloadmodel(p->mdl);
					if(DEBUG_WORLD)
						conoutf(CON_DEBUG, "DEBUG: preloading %s", p->mdl);
				}
			}
		}
	}

	void suicide(physent *d)
	{
		((rpgent *) d)->die();
	}

	void physicstrigger(physent *d, bool local, int floorlevel, int waterlevel, int material)
	{
		if(d->state!=CS_ALIVE||d->type==ENT_INANIMATE) return;
		switch(material)
		{
			case MAT_LAVA:
				if (waterlevel==0) break;
				playsound(S_BURN, d==player1 ? NULL : &d->o);
				loopi(60)
				{
					vec o = d->o;
					o.z -= d->eyeheight *i/60.0f;
					regular_particle_flame(PART_FLAME, o, 6, 2, 0x903020, 3, 2.0f);
					regular_particle_flame(PART_SMOKE, vec(o.x, o.y, o.z + 8.0f), 6, 2, 0x303020, 1, 4.0f, 100.0f, 2000.0f, -20);
				}
				break;
			case MAT_WATER:
				if (waterlevel==0) break;
				playsound(waterlevel > 0 ? S_SPLASH1 : S_SPLASH2 , d==player1 ? NULL : &d->o);
				particle_splash(PART_WATER, 200, 200, d->o, (watercolor.x<<16) | (watercolor.y<<8) | watercolor.z, 0.5);
				break;
			default:
				if (floorlevel==0) break;
				playsound(floorlevel > 0 ? S_JUMP : S_LAND, local ? NULL : &d->o);
				break;
		}
	}

	///NOTE: dist is a multiplier for the delta between from and to, if there's 10 units difference and you need to travel 5, dist is 0.5
	bool intersect(rpgent *d, const vec &from, const vec &to, float &dist)   // if lineseg hits entity bounding box
	{
		vec bottom(d->o), top(d->o);
		bottom.z -= d->eyeheight;
		top.z += d->aboveeye;
		return linecylinderintersect(from, to, bottom, top, d->radius, dist);
	}

	rpgent *intersectclosest(const vec &from, const vec &to, rpgent *at, float &bestdist, float maxdist)
	{
		rpgent *best = NULL;
		bestdist = maxdist;
		float dist;

		loopv(curmap->objs)
		{
			rpgent *o = curmap->objs[i];
			if(o == at || !intersect(o, from, to, dist)) continue;

			if(dist < bestdist)
			{
				best = o;
				bestdist = dist;
			}
		}

		return best;
	}

	bool showenthelpers()
	{
		return editmode;
	}

	bool ispaused()
	{
		if(rpggui::open()) return true;
		return false;
	}

	bool canjump()
	{
		respawn();
		return player1->state!=CS_DEAD;
	}

	bool mousemove(int &dx, int &dy, float &cursens)
	{
		if(camera::cutscene)
			return true; //disable mouse input

		return false;
	}

	void newmap(int size)
	{
		if(size < 0) return;

		if(!mapdata) newgame("default");
		emptymap(size, true);
		if(!connected) localconnect();
	}
	ICOMMAND(newmap, "i", (int *size), newmap(max(0, *size));) ///overrides built in variant - we want to reset the game state before creating entities

	void gameconnect(bool _remote) {if(!mapdata) newgame("default"); connected = true;}

	void openworld(const char *name, bool fall = false)
	{
		if(!mapdata)
		{
			if(DEBUG_WORLD) conoutf(CON_DEBUG, "DEBUG: no game in progress, falling back to default");
			newgame("default");
		}
		if(!connected) localconnect();

		if(name && *name && load_world(name))
			return;
		else if(fall && load_world(DEFAULTMAP))
			return;
		else
			emptymap(10, true, "untitled");
	}

	ICOMMAND(map, "s", (char *s), openworld(s, false))

	void changemap(const char *name) { openworld(name, true); }
	void forceedit(const char *name) { openworld(name, false); }

	void gamedisconnect(bool cleanup)
	{
		cleangame();

		connected = false;
	}

	const char *getclientmap() { return curmap ? curmap->name : ""; }
	void edittrigger(const selinfo &sel, int op, int arg1, int arg2, int arg3) {}

	void resetgamestate() {}

	bool cansave()
	{
		if(camera::cutscene || rpggui::open())
		{
			conoutf("You may not save at this time");
			return false;
		}
		return true;
	}

	VARP(edittogglereset, 0, 1, 1);

	void edittoggled(bool on)
	{
		entities::intents.setsize(0);
		if(!on && curmap)
		{
			if(edittogglereset)
			{
				if(DEBUG_WORLD)
					conoutf(CON_DEBUG, "DEBUG: resetting game state for current map");

				curmap->objs.removeobj(player1);

				curmap->objs.deletecontents();
				curmap->projs.deletecontents();
				curmap->aeffects.deletecontents();
				curmap->blips.setsize(0);

				curmap->objs.add(player1);
				rpgscript::domapscript(curmap, NULL, MSCR_LOAD);
			}

			entities::genentlist();
		}

	}

	const char *getmapinfo()
	{
		if(tips.length())
		{
			lasttip = rnd(tips.length());
			return tips[lasttip];
		}
		lasttip = -1;
		return NULL;
	}

	dynent *iterdynents(int i)
	{
		if(curmap)
		{
			if(i <curmap->objs.length())
				return curmap->objs[i];
		}
		else
		{
			if(DEBUG_WORLD)
				conoutf(CON_DEBUG, "DEBUG: dynent requested while not in a game, returning player");
			return player1;
		}

		return NULL;
	}

	int numdynents()
	{
		return curmap ? curmap->objs.length() : 0;
	}

	const char *gameident()		{return "rpg";}
	const char *autoexec()		{return "autoexec.cfg";}
	const char *savedservers()	{return NULL;}

	//TODO write game version
	void writegamedata(vector<char> &extras) {}
	void readgamedata (vector<char> &extras) {}

	void writemapdata(stream *f) {} //do we save rpg declarations per map or not?
	void loadconfigs() {}
	void texturefailed(char* name, int slot) {}
	void mmodelfailed(const char *name, int idx) {}
	void mapfailed(const char *name) {}
	bool allowdoublejump() { return false; }
	bool detachcamera() { return player1->state == CS_DEAD; }

}
