#include "rpggame.h"

///@TODO write some directives and implement them here

//patrol - moves around in a singular area, engages stuff if needed and returns here afterwards

//attack - attacks and hunts down the entity. will atempt to search and find the entity before going on with whatever they were doing
//NOTE 1: if target is invisible make them swipe the air randomly
//NOTE 2: call for help or flee if buddies are killed

//move - move to position entity with the specified tag, or to specific coordinits

//interact - interacts with stuff, ie pick up items

//flee - flees, preferably to a nearby safezone

//watch - watches a creature

//follow - follows a creature, like a companion

//guard - like follow, but helps them in fights

//stay - stay in the same spot

namespace ai
{
	enum
	{
		D_PATROL = 0,
		D_ATTACK,
		D_MOVE,
		D_INTERACT,
		D_FLEE,
		D_FOLLOW,
		D_GUARD
	};

	struct patrol : directive
	{

	};

	struct attack : directive
	{

	};

	struct move : directive
	{
		vec pos;

		move(vec &o) : pos(o) {}
		~move() {}

		int priority() {return 0;}
		int type() {return D_MOVE;}
		bool update(rpgchar *d)
		{
			if(pos.dist(d->o) > 16)
				return false;

			d->dest = pos;
			return true;
		}
	};

	struct interact : directive
	{

	};

	struct flee : directive
	{

	};

	struct follow : directive
	{

	};

	struct guard : directive
	{

	};

	#define checkentsel \
		rpgchar *entsel = (rpgchar *)rpgscript::entsel; \
		if(!entsel) return; \
		if(entsel->type() != ENT_CHAR) \
		{ \
			conoutf(CON_ERROR, "ERROR: Directives are only available to characters; FIX YOUR SCRIPTS; type %i script? %i name %s", \
				entsel->type(), entsel->getscript(), entsel->getname() \
			); \
			return; \
		}


	ICOMMAND(r_action_clear, "", (),
		if(DEBUG_AI) conoutf(CON_DEBUG, "DEBUG: attempting to clear directives for entity %p", rpgscript::entsel);
		checkentsel
		entsel->directives.deletecontents();
	)
}

#if 0
///base functions


VAR(chase, 0, 0, 1);

void rpgai::update()
{
	rpgchar::update();

	if(state == CS_DEAD)
		return;

	waypoint *closest = ai::closestwaypoint(feetpos());

	if(closest && closest->o.dist(feetpos()) < 20 && !route.length())
	{
		ai::findroute(closest - ai::waypoints.getbuf(), rnd(ai::waypoints.length()), route);
	}
	else
		followroute();

	//just something stupid :P

	if(state != CS_ALIVE || !chase)
		return;

	if(cansee(game::player1))
	{
		if(closest && (!route.length() || ai::waypoints[route.last()].o.dist(game::player1->o) >= 64))
		{
			route.setsize(0);
			int target = ai::closestwaypoint(game::player1->feetpos()) - ai::waypoints.getbuf();
			ai::findroute(closest - ai::waypoints.getbuf(), target, route);
		}
		vec dir = vec(game::player1->o).sub(o);
		vectoyawpitch(dir, yaw, pitch);

		if(lastmillis - lastaction > 1000)
		{
			lastaction = lastmillis;

			if(!game::effects.length())
				return;

			projectile *p = new projectile();
			p->init(this, NULL, projectile::INIT_ADJUST, rnd(15) + 1);

			p->fx = rnd(game::effects.length());
			p->gravity = rnd(51) - 25;

			game::curmap->projs.add(p);
		}
	}
}

///Character/AI
void rpgai::die(rpgent *killer)
{
	rpgchar::die(killer);
	route.setsize(0);
}

///AI specific functions
void rpgai::followroute()
{
	if(!route.length())
	{
		strafe = move = 0;
		return;
	}

	int ind;
	waypoint *closest = ai::closestwaypoint(feetpos());
	if(!closest) // this should not happen
	{
		route.setsize(0);
		return;
	}

	ind = closest - ai::waypoints.getbuf();

	if(ind == route[0] && closest->o.dist(feetpos()) < 8)
		route.remove(0);

	if(!chase || !cansee(game::player1))
	{
		strafe = 0;
		move = 1;
		vec dir = vec(ai::waypoints[route[0]].o).sub(feetpos());
		vectoyawpitch(dir, yaw, pitch);
	}
	else
	{
		strafe = move = 0;

		vec dir = vec(ai::waypoints[route[0]].o).sub(feetpos());
		dir.z = 0; dir.normalize();
		dir.rotate_around_z(-yaw * RAD);

		if(fabs(dir.y) >= .7)
			move = dir.y < 0 ? -1 : 1;
		if(fabs(dir.x) >= .7)
			strafe = dir.x < 0 ? -1 : 1;
	}
}

bool rpgai::cansee(rpgent *d)
{
	//TODO     add in modifiers for sound, movement, light, invisibility and perception
	//TODO 2   do extra checks and stuff for fog (both in water and out)!

	//at present this will only see if the entity is within this creature's LoS
	vec dir = vec(d->o).sub(o).normalize();
	vec view = vec(yaw * RAD, pitch * RAD);

	if(dir.dot(view) >= .5)
	{
		vec pos;
		float dist = raycubepos(o, dir, pos, 0, RAY_ALPHAPOLY|RAY_CLIPMAT);
		if(o.dist_to_bb(d->feetpos(), d->abovehead()) <= dist)
			return true;
	}

	return false;
}
#endif
