function %helps=initial_help_chapters(language)
[lhs,rhs]=argn(0)
if rhs==0 then
  language="eng"
else
  if rhs<>1 then error(39), end
end
dirs=["programming";"graphics";"elementary";"fileio";"functions";"strings";
      "gui";"utilities";"linear";"polynomials";"control";"robust";
      "nonlinear";"signal";"arma";"metanet";"scicos";"sound";"translation";
      "pvm";"tdcs";"tksci";"statistics";"dcd";"identification"];
sep="/";if MSDOS then sep="\",end
%helps=sep+"man"+sep+language+sep+dirs; 
select language
case "eng"
  %helps=[%helps,..
	  ["Programming";"Graphics Library";"Elementary Functions";
	   "Input/Output Functions";"Handling of functions and libraries";
	   "Character string manipulations";"Dialogs";"Utilities";
	   "Linear Algebra";"Polynomial calculations";
	   "General System and Control";"Robust control toolbox";
	   "Optimization and simulation";
	   "Signal Processing toolbox";
	   "Arma modelisation and simulation toolbox";
	   "Metanet: graph and network toolbox";
	   "Scicos: Bloc diagram editor and simulator";"Sound file handling";
	   "Language or data translations";"PVM parallel toolbox";"TdCs";
	   "TCL/Tk interface";
	   "Statistics";
	   "Cumulative Distribution Functions; Inverses, grand";
           "Identification"]];
  case "fr"
  %helps=[%helps,..
	  ["Programmation";"Librairie graphique";"Fonctions lmentaires";
	   "Entres-sorties";"Manipulation des fonctions et des librairies";
	   "Manipulations de chanes de caractres";"Dialogues";"Utilitaires";
	   "Algbre linaire";"Calculs sur les polynmes";
	   "Contrle et thorie des systmes";"Contrle robuste";
	   "Optimisation et simulation";
	   "Traitement du signal";"Modlisation et simulation ARMA";
	   "Metanet : graphes et rseaux";
	   "Scicos : diteur et simulateur de blocs diagrammes";
	   "Manipulation de fichiers sons";
	   "Gnration de code, traduction de donnes";
	   "Calcul parallle avec PVM";"TdCs";
	   "Interface TCL/Tk";
	   "Statistiques";
	   "Fonctions de distributions statistiques";
           "Identification"]];
end
%helps=[SCI+%helps(:,1),%helps(:,2)];
