#include "seaview.h"
#include <stdlib.h>
#include <ctype.h>
#include <FL/Fl_Check_Button.H>
#ifdef unix
#include <unistd.h>
#endif
#ifdef WIN32
#define tempnam _tempnam
#endif

#define MAX_MSA_ALGOS 10 //max # of alignment methods allowed in Props menu

/* local prototypes */
int save_part_as_pir(int debut, int fin, char **sequence, char **seqname, 
	int *sel_seqs, int tot_seqs, char *fname, int *withU, int *empty_seq,
	int *num_longest, int protein, int align_everything);
int replace_align_part(SEA_VIEW *view, int debut, int fin, char *fname, int withU, int num_longest,
	int has_phylip_format, int align_everything);
void align_selected_parts(SEA_VIEW *view, int align_algorithm, int align_everything);
int calc_gap_sites(char *old_seq, char *new_seq, int lold, int lnew, 
	gap_site *gap_sites, int maxsites);
int insert_gaps_new_align(char **seq, int site, int number, int numseqs, 
	int lseqs);
int reset_stars(SEA_VIEW *view, int debut, int lpart, char **seq, int lfrag, int align_everything);
int confirm_refer_seq(int num_longest, SEA_VIEW *view);
int calc_msa_command(SEA_VIEW *view, char *base_fname, char *command);
void cre_align_opt_menu(SEA_VIEW *view, Fl_Menu_Button *obj, props_menu_parts *parts);
void align_opt_callback(Fl_Widget *ob, void *data);
char *get_algo_opts(int algonum /* from 0 */, char **presname);
char *get_opt_resname(int algonum);
void set_algo_option_item(char *opts, Fl_Menu_Button *menu, int itemrank, int checkit);
void add_align_callback(Fl_Widget *ob, void *data);
void delete_align_callback(Fl_Widget *ob, void *data);
void add_align_w_callback(Fl_Widget *ob, void *data);
void edit_align_callback(Fl_Widget *ob, void *data);
void init_msa_algos(void);

/* extern proto */
extern int insert_gaps_at(SEA_VIEW *view, int seq, int site, int total);
extern int insert_gap_all_comments(int numgaps, int pos,  SEA_VIEW *view);
extern void del_gap_only_sites(SEA_VIEW *view);
extern char *get_res_value(char *name, char *def_value);
extern int int_res_value(char *name, int def_value);
extern int set_res_value(const char *name, const char *value);
extern void delete_res_value(char *name);
extern void save_resources(void);
#ifdef WIN32
extern char *MG_win32_file_chooser(const char* message,
        const char* pattern,
        const char* fname,
        const char* defext,
        bool save, int *pfilterindex);
extern "C" { int mysystem(const char *command); }
#elif defined(__APPLE__)
extern char* MAC_file_chooser(const char* message, const char* pat, const char* fname);
extern "C" {
	int my_system_macho(char *command, char *base_fname);
	}
#else
void change_attr(Fl_Window *w);
#endif


/* extern variables */
extern gap_site gap_sites[];


int save_part_as_pir(int debut, int fin, char **sequence, char **seqname, 
	int *sel_seqs, int tot_seqs, char *fname, int *withU, int *empty_seq,
	int *num_longest, int protein, int align_everything)
/* returns TRUE iff error */
{
FILE *out;
int num, pos, l_line, retval, maxlen, seqlen, current;
char line[90];

out = fopen(fname,"w");
if( out == NULL ) return TRUE;
retval = TRUE;
*withU = FALSE;
maxlen = 0; current = 0;
for(num = 0; num < tot_seqs; num++) {
	if(! (align_everything ||  sel_seqs[num] ) ) continue;
	sprintf(line, "%d_%s", ++current, seqname[num]);
	fprintf(out, ">%.10s\n", line);
	if(ferror(out)) goto fin;
	*empty_seq = TRUE;
	l_line = 0;
	seqlen = 0;
	for ( pos = debut - 1 ; pos < fin; pos++) {
		if( sequence[num][pos] == 0 ) break;
		if( sequence[num][pos] == '-' ) continue;
		if(l_line >= 70) {
			line[l_line] = 0;
			if(!*withU) *withU = (strchr(line, 'U') != NULL);
			fprintf(out, "%s\n", line);
 			if(ferror(out)) goto fin;
			seqlen += l_line;
			l_line = 0;
			}
		line[l_line++] = sequence[num][pos];
		if(sequence[num][pos] == '*') line[l_line - 1] = 'X';
		*empty_seq = FALSE;
		}
	line[l_line] = 0;
	seqlen += l_line;
	if(seqlen > maxlen) {
		maxlen = seqlen; *num_longest = num;
		}
	if(!*withU) *withU = (strchr(line, 'U') != NULL);
	fprintf(out, "%s\n", line);
	if( *empty_seq ) strcpy(fname, seqname[num]);
	if(ferror(out) || *empty_seq) goto fin;
	}
retval = FALSE;
fin:
if( fclose(out) != 0) return TRUE;
return retval;		
}


void align_selected_parts(SEA_VIEW *view, int align_algorithm, int align_everything)
{
int debut, fin, status, withU, empty_seq, num_longest, l;
char *p;
static char base_fname[100], commande[300];

#if ! ( defined(WIN32)  ||  defined(__APPLE__) )
/* check for presence of xterm + seaview_align.sh */
	status = get_full_path("xterm") == NULL;
	if(status == 0) {
		status = get_full_path("seaview_align.sh") == NULL;
		}
	if(status != 0) {
		fl_message("Alignment operation is impossible because\n"
		  "one of the programs xterm, seaview_align.sh\n"
		  "is missing");
		((Fl_Menu_ *)view->menu_edit)->mode(ALIGN_ALL_SEQS, FL_MENU_INACTIVE);
		((Fl_Menu_ *)view->menu_edit)->mode(ALIGN_SELECTION, FL_MENU_INACTIVE);
		return;
		}
#endif
if( (!align_everything) && (view->active_region == NULL || view->active_region->list == NULL ||
	view->active_region->list->next != NULL || view->tot_sel_seqs <= 1) ) {
	fl_message("Need to have exactly one block of selected sites\n"
		"and some selected sequences");
	return;
	}
#if !( defined(WIN32) || defined(__APPLE__) )
/* mettre fenetres en Backing Store State: WhenMapped */
change_attr( view->DNA_obj->window() ); 
change_attr( view->dnawin ); 
#endif
if(align_everything) {
	debut = 1;
	fin = view->seq_length;
	}
else	{
	debut = view->active_region->list->debut;
	fin = view->active_region->list->fin;
	}
#if  defined(WIN32)  ||  defined(__APPLE__)
strcpy(base_fname, tempnam(NULL, "seaviewtemp_")); 
#else
strcpy(base_fname, "/tmp/seaview.XXXXXX");
if(mktemp(base_fname) == NULL) return;
#endif
/* 
convertir en minuscules car clustalw n'accepte pas les majuscules ds filenames
*/
p = base_fname - 1; while( *(++p) != 0) *p = tolower( *p);
sprintf(commande, "%s.pir", base_fname);
/* allonger les seqs plus courtes que la region traitee */
for(l = 0; l < view->tot_seqs; l++) {
	if(!(align_everything || view->sel_seqs[l]) ) continue;
	if(fin > view->each_length[l]) insert_gaps_at(view, l + 1, 
			view->each_length[l] + 1, fin - view->each_length[l]);
	}
status = save_part_as_pir(debut, fin, view->sequence, view->seqname, 
	view->sel_seqs, view->tot_seqs, commande, &withU, &empty_seq, 
	&num_longest, view->protein, align_everything);
if(view->protein) withU = FALSE;
if(empty_seq) {
	fl_alert("Cannot process sequence(s)\n%s\n"
		 "containing only gaps", commande);
	}
if( (!empty_seq) && status) {
	fl_alert("Cannot write sequences to filename\n%s", commande);
	return;
	}
if(!(empty_seq || align_everything) ) num_longest = confirm_refer_seq(num_longest, view);
if(num_longest == -1 || empty_seq) {
	sprintf(commande, "%s.pir", base_fname);
	remove(commande);
	return;
	}
my_watch_cursor(view->dnawin);

status = calc_msa_command(view, base_fname, commande);
if(status) return;
#ifdef WIN32
status = mysystem(commande);
#elif defined(__APPLE__)
status = my_system_macho(commande, base_fname);
#else
status = system(commande);
if( status == 0 ) {
	sprintf(commande, "%s.status", base_fname);
	FILE *in = fopen(commande, "r");
	if(in != NULL) {
		fgets(commande, sizeof(commande), in);
		if( strcmp(commande, "success\n") != 0) status = 1;
		fclose(in);
		}
	else	status = 1;
	}
#endif
sprintf(commande, "%s.out", base_fname);
if( status == 0 ) {
	FILE *in = fopen(commande, "r");
	if(in != NULL) {
		fseek(in, 0, SEEK_END);
		status = (ftell(in) < 10);
		fclose(in);
		}
	else	status = 1;
	}
if( status != 0 )
	fl_message("Alignment operation ignored");
else	{
	status = replace_align_part(view, debut, fin, commande, withU, num_longest,
		 FALSE, 
		align_everything );
	if(status) fl_alert("Not enough memory\nor\n" 
		"max sequence length reached");
	}
sprintf(commande, "%s.pir", base_fname);
remove(commande);
sprintf(commande, "%s.out", base_fname);
remove(commande);
sprintf(commande, "%s.dnd", base_fname);
remove(commande);
#ifndef WIN32
sprintf(commande, "%s.status", base_fname);
remove(commande);
#endif
}


int calc_gap_sites(char *old_seq, char *new_seq, int lold, int lnew, 
	gap_site *gap_sites, int maxsites)
{
char *fin_old, *fin_new;
int tot_sites = 0, posalign = 0;
fin_old = old_seq + lold - 1; fin_new = new_seq + lnew - 1;
while( old_seq <= fin_old || new_seq <= fin_new ) {
	if(old_seq <= fin_old && new_seq <= fin_new && 
		( ( *old_seq != '-' && *new_seq != '-') ||
		  ( *old_seq == '-' && *new_seq == '-') ) ){
		old_seq++; new_seq++;
		posalign++;
		continue;
		}
	if(tot_sites >= maxsites) return -1;
	gap_sites[tot_sites].l[1] = 0;
	gap_sites[tot_sites].l[0] = 0;
	if(old_seq <= fin_old && *old_seq == '-') {
		gap_sites[tot_sites].pos = posalign;
		do	{ old_seq++; ++(gap_sites[tot_sites].l[1]); }
		while( *old_seq == '-' && old_seq < fin_old);
		posalign += gap_sites[tot_sites].l[1];
		}
	else 	{
		gap_sites[tot_sites].pos = posalign;
		do	{ new_seq++; ++(gap_sites[tot_sites].l[0]); }
		while( *new_seq == '-' && new_seq < fin_new);
		posalign += gap_sites[tot_sites].l[0];
		}
	tot_sites++;
	}
return tot_sites;
}


int replace_align_part(SEA_VIEW *view, int debut, int fin, char *fname, 
	int withU, int num_longest, int has_phylip_format, int align_everything)
/* returns TRUE if error, FALSE if ok */
{
int num, lfrag, lpart, i, col, rang, retval, newlength, lfrag2, total;
char **seq, **comments, **seqname, *pheader, *err_message;
int (*calc_color_function)(int);
int totgapsites, num1, site, l_copy, res;
char *tmp;

total = (align_everything ? view->tot_seqs : view->tot_sel_seqs);
view->cursor_in_comment = FALSE;
view->cursor_seq = view->first_seq;
/* lecture de l'alignement multiple produit par clustalw */
num = (has_phylip_format ?
	read_phylip_align(fname, &seq, &seqname, &comments, &pheader, &err_message)
	:
	read_fasta_align(fname, &seq, &seqname, &comments, &pheader, &err_message)
	);
for(i = 0; i < num; i++) free(seqname[i]);
if(num > 0) { free(seqname); free(comments); }
if( num != total) {
	if(num > 0) free(seq); 
	return TRUE; 
	}

retval = TRUE;
if(withU) { 
/* si seq avec U au depart, les remettre car ont ete changes en T par clustalw */
	char *p, *q;
 	for(num = 0; num < total; num++) {
 		p = seq[num];
 		while( (q = strchr(p, 'T')) != NULL) { *q = 'U'; p = q; }
		}
	}	
lfrag = strlen(seq[0]); /* long alignement de clustalw */
lpart = fin - debut + 1; /*long region traitee de l'ancien alignement multiple*/
if( reset_stars(view, debut, lpart, seq, lfrag, align_everything) ) return TRUE;
/* num1 = rang dans align clustalw de num_longest dans align multiple */
num1 = -1;
for(i = 0; i < view->tot_seqs; i++) {
	if( !(align_everything || view->sel_seqs[i]) ) continue;
	num1++;
	if( i == num_longest) break;
	}
/* calcul des pos et longs de gaps a inserer:
gap_sites[x].pos = position a droite du gap a inserer (from 0)
gap_sites[x].l[0] = longueur a inserer dans alignement multiple
gap_sites[x].l[1] = longueur a inserer dans alignement produit par clustalw
*/
totgapsites = calc_gap_sites(view->sequence[num_longest] + debut - 1, seq[num1],
	FL_min(lpart, view->each_length[num_longest] - debut + 1),
	lfrag, gap_sites, MAX_GAP_SITES);
if(totgapsites == -1) goto fin;
/* calcul long region traitee apres ajout des gaps */
for(site=0; site<totgapsites; site++) 
	lpart += gap_sites[site].l[0];
/* l'alignement multiple serait-il trop long en fin d'operation? */
if( view->seq_length + lpart - (fin - debut + 1) > view->max_seq_length ) 
	goto fin;
/* calcul long alignement de clustalw apres ajout des gaps */
lfrag2 = lfrag;
for(site = 0; site < totgapsites; site++) 
	lfrag2 += gap_sites[site].l[1];
/* allongement memoire pour seqs de l'alignement de clustalw */
for(num=0; num<total; num++) {
	tmp = (char *)malloc(lfrag2+1);
	if(tmp == NULL) goto fin;
	memcpy(tmp, seq[num], lfrag+1);
	free(seq[num]);
	seq[num] = tmp;
	}
/* allongement des seqs de l'alignement de clustalw */
for(site = 0; site < totgapsites; site++) {
	if(gap_sites[site].l[1] == 0) continue;
	lfrag = insert_gaps_new_align(seq, gap_sites[site].pos, 
		gap_sites[site].l[1],
		total, lfrag);
	}
if(view->numb_gc > 1) {
	calc_color_function = ( view->protein ? 
		get_color_for_aa : get_color_for_base );
	}
newlength = view->seq_length;
/* allongement des seqs de l'alignement multiple */
for(site = 0; site < totgapsites; site++) {
	if(gap_sites[site].l[0] == 0) continue;
	for(num = 0; num < view->tot_seqs; num++) {
		insert_gaps_at(view, num + 1, 
			debut + gap_sites[site].pos, gap_sites[site].l[0]);
		}
	newlength += gap_sites[site].l[0];
	insert_region_part(view, debut + gap_sites[site].pos, 
		gap_sites[site].l[0]);
	if(view->tot_comment_lines > 0) insert_gap_all_comments(
		gap_sites[site].l[0], debut + gap_sites[site].pos, view);
	}

/* copie des sequences de clustalw vers alignement multiple */
rang = -1;
for(num = 0; num < view->tot_seqs; num++) {
	if(  ! (align_everything || view->sel_seqs[num]) ) continue;
	rang++;
/* on met les nouvelles seqs */ 
	l_copy = FL_min(lpart, lfrag);
	memcpy( view->sequence[num] + debut - 1, seq[rang], l_copy);
	if(debut + l_copy - 1 > view->each_length[num])
		view->each_length[num] = debut + l_copy - 1;
	newlength = FL_max(newlength, view->each_length[num]);
	if(view->each_length[num] == debut + l_copy - 1) 
		view->sequence[num][debut + l_copy - 1] = 0;
	if(view->numb_gc == 1) continue;
	for(i = 0; i < view->numb_gc; i++) {
		memset( view->col_seq[num][i] + debut - 1, ' ', l_copy);
		}
	for(i = debut - 1; i < debut + l_copy - 1; i++) {
		res = view->sequence[num][i];
		col = calc_color_function( res );
		view->col_seq[num][col][i] = 
			(view->allow_lower ? res : toupper(res) );
		}
	if(view->each_length[num] == debut + l_copy - 1) {
		for(col = 0; col < view->numb_gc; col++) 
			view->col_seq[num][col][debut + l_copy - 1] = 0;
		}
	}
/* mettre a jour horsli */
update_current_seq_length(newlength, view);
if(align_everything) del_gap_only_sites(view);
view->modif_but_not_saved = TRUE;
retval = FALSE;

fin:
for(num = 0; num < total; num++) 
	free(seq[num]);
free(seq);
return retval;
}


int insert_gaps_new_align(char **seq, int site, int number, int numseqs, 
	int lseqs)
{
int num;
char *pos;
for(num=0; num < numseqs; num++) {
	pos = seq[num] + site;
	memmove(pos + number, pos, lseqs - site + 1);
	memset(pos, '-', number);
	}
return lseqs + number;
}


int reset_stars(SEA_VIEW *view, int debut, int lpart, char **seq, int lfrag, int align_everything)
{
int oldseq, newseq;
char *p, *q;

newseq = -1;
for(oldseq = 0; oldseq < view->tot_seqs; oldseq++) {
	if(!(align_everything || view->sel_seqs[oldseq])) continue;
	newseq++;
	p = view->sequence[oldseq] + debut - 2;
	q = seq[newseq] - 1;
	while(TRUE) {
		p++; q++;
		while (*p == '-') p++;
		while (*q == '-') q++;
		if(*p == 0 || *q == 0) break;
		if( *p == '*' && *q == 'X') *q = '*';
		if( toupper(*p) != toupper(*q) ) return TRUE;
		if( islower(*p) ) *q = *p;
		}
	}
return FALSE;
}


int confirm_refer_seq(int num_longest, SEA_VIEW *view)
{
static Fl_Window *form;
static int first = TRUE;
static Fl_Browser *browser_noms;
static Fl_Button *ok_button, *cancel_button;
int lnum, i;
if(first) {
	first = FALSE;
	form = new Fl_Window( 300, 400);
	form->label("Reference Sequence");
	form->box(FL_FLAT_BOX);
	fl_font(FL_HELVETICA, FL_NORMAL_SIZE);
	browser_noms = new Fl_Browser(5, 5 + fl_height(), form->w() - 10, 
		form->h() - 35 - fl_height(), "Choose one seq.");
	browser_noms->type(FL_HOLD_BROWSER);
	browser_noms->textsize(FL_NORMAL_SIZE);
	browser_noms->has_scrollbar(Fl_Browser_::VERTICAL);
	browser_noms->align(FL_ALIGN_TOP);
	browser_noms->color(FL_LIGHT1, browser_noms->selection_color());
	ok_button = new Fl_Return_Button(5, form->h() - 25, 
		browser_noms->w() / 2, 20, "OK");
	cancel_button = new Fl_Button(ok_button->x() + ok_button->w(), 
		ok_button->y(), ok_button->w(), ok_button->h(), "Cancel");
	form->resizable(browser_noms);
	form->end();
	form->set_modal();
	}
browser_noms->clear();
lnum = 0;
for(i = 0; i < view->tot_seqs; i++) {
	if(!view->sel_seqs[i]) continue;
	lnum++;
	browser_noms->add(view->seqname[i]);
	if(i == num_longest) browser_noms->value(lnum);
	}
form->show();
for (;;) {
	Fl_Widget *o = Fl::readqueue();
	if (!o) Fl::wait();
	else if(o == cancel_button ) { num_longest = -1; break; }
	else if(o == ok_button && browser_noms->value() != 0) break;
	}
form->hide();
if(num_longest == -1) return -1;
Fl::flush();

lnum = browser_noms->value();
for(i = 0; i < view->tot_seqs; i++) {
		if(!view->sel_seqs[i]) continue;
		if(strcmp(view->seqname[i], browser_noms->text(lnum)) == 0) {
			num_longest = i;
			break;
			}
		}
return num_longest;
}


int calc_msa_command(SEA_VIEW *view, char *base_fname, char *command)
{
char algo_name[50];
char local[300], tmp[300], *p, *optargs;
int status;

sprintf(tmp, "msa_name_%d", view->alignment_algorithm +  1);
strcpy(algo_name, get_res_value(tmp, NULL) );
/* check if program present */
#if defined(WIN32)
char w32path[300];
strcpy(tmp, algo_name);
if(strchr(algo_name, '\\') == NULL && strchr(algo_name, '.') == NULL) strcat(tmp, ".exe");
p = get_full_path(tmp);
if(p != NULL) strcpy(w32path, p);
status = (p == NULL);
#else
status = (get_full_path(algo_name) == NULL);
#endif
if(status) {
	sprintf(tmp, "Alignment is impossible because program  '%s'  is not found", algo_name);
	fl_message(tmp);
	return 1;
	}
	
sprintf(tmp, "msa_args_%d", view->alignment_algorithm +  1);
strcpy(local, get_res_value(tmp, NULL));

/* add user-entered options to command */
Fl_Menu_Button *menu_props = (Fl_Menu_Button *)view->bouton_props;
props_menu_parts *parts = 
		(props_menu_parts *)menu_props->user_data();
optargs = get_algo_opts(view->alignment_algorithm, NULL);
status = menu_props->mode(parts->clustalopt + MAX_MSA_ALGOS );
if(optargs != NULL && (status & FL_MENU_VALUE) ) {
	if((p=strchr(local, '>')) != NULL) {
		*p = 0;
		sprintf(tmp, "%s %s > %s", local, optargs, p + 1);
		}
	else {
		sprintf(tmp, "%s %s", local, optargs);
		}
	strcpy(local, tmp);
	}
/* replace all %f by file names */
while((p = strstr(local, "%f")) != NULL) {
	*p = 0;
	sprintf(tmp, "%s%s%s", local, base_fname, p+2);
	strcpy(local, tmp);
	}
/* build complete command string */
#if defined(__APPLE__)
sprintf(command, "#!/bin/sh\n\"%s\" %s ", get_full_path(algo_name), local);
#elif defined(WIN32)
sprintf(command, "cmd.exe /c \"%s\" %s ", w32path, local);
#else
/* if present, > must be protected by '' before sending to xterm */
if((p=strchr(local, '>')) != NULL) {
	memmove(p+3, p+1, strlen(p+1) + 1);
	memcpy(p, "'>'", 3);
	}
sprintf(command, "xterm -T \"%s alignment\" -n %s -sb -sl 2000 -e seaview_align.sh %s %s %s ", 
	algo_name, algo_name, algo_name, base_fname, local);
#endif
return 0;
}


void cre_align_opt_menu(SEA_VIEW *view, Fl_Menu_Button *obj, props_menu_parts *parts)
{
char msa_name[60], *name; 
int elt, attr;

obj->add("Alignment options", 0, 0, 0, FL_SUBMENU);
for(elt = 1; elt <= MAX_MSA_ALGOS; elt++) {
	sprintf(msa_name, "Alignment options/hidden_%d", elt);
	attr = FL_MENU_RADIO; 
	if(elt == view->count_msa_algos) attr |= FL_MENU_DIVIDER;
	if(elt > view->count_msa_algos) attr |= FL_MENU_INVISIBLE;
	attr = obj->add(msa_name, 0, align_opt_callback, parts, attr);
	if(elt == 1) parts->clustalopt = attr;
	if(elt <= view->count_msa_algos) {
		sprintf(msa_name, "msa_name_%d", elt);
		name = get_res_value(msa_name, NULL);
		obj->replace(parts->clustalopt + elt - 1, name );
#ifndef WIN32
		if(get_full_path(name) == NULL) {
			attr = obj->mode(parts->clustalopt + elt - 1);
			obj->mode(parts->clustalopt + elt - 1, attr | FL_MENU_INACTIVE);
			} 
#endif
		}
	}
((Fl_Menu_Item *)obj->menu() + parts->clustalopt + view->alignment_algorithm)->set();
name = get_algo_opts(view->alignment_algorithm, NULL);
sprintf(msa_name, "Alignment options/%s", name == NULL ? "<none>" : name);
attr = FL_MENU_TOGGLE;
if(name == NULL) attr |= FL_MENU_INACTIVE;
obj->add(msa_name, 0, NULL, parts, attr);
obj->add("Alignment options/Edit options", 0, edit_align_callback, parts, FL_MENU_DIVIDER);
obj->add("Alignment options/Add external method", 0, add_align_w_callback, parts, 0);
if(view->alignment_algorithm < 2) attr = FL_MENU_INACTIVE;
else attr = 0;
obj->add("Alignment options/Delete method", 0, delete_align_callback, parts, attr);
}


void add_align_callback(Fl_Widget *ob, void *data)
{
if(data == NULL) {
	ob->window()->hide();
	return;
	}
char tmp[200];
int doit = TRUE, x;
props_menu_parts *parts = (props_menu_parts *)data;
SEA_VIEW *view = parts->view;
Fl_Menu_Button *menu_props = (Fl_Menu_Button *)view->bouton_props;

Fl_Window *w = ob->window();
Fl_Widget **all = (Fl_Widget **)w->array();
const char *name = ((Fl_Input *)all[0])->value();
const char *args = ((Fl_Input *)all[1])->value();
for(x = 0; x < view->count_msa_algos; x++) {
	if(strcmp(name, ((Fl_Menu_Item *)menu_props->menu() + parts->clustalopt + x)->label() ) == 0) doit = FALSE;
	}
if(doit) doit = (name != NULL && args != NULL && strlen(name) >= 2 && strlen(args) >= 2);
#ifdef WIN32
strcpy(tmp, name);
if(strchr(tmp, '\\') == NULL && strchr(tmp, '.') == NULL) strcat(tmp, ".exe");
if(get_full_path(tmp) == NULL) {
#else
if(get_full_path(name) == NULL) {
#endif
	fl_alert("Program  '%s'  not found.\nMethod won't be added.", name);
	doit = FALSE;
	}
if(doit) {
	menu_props->replace(parts->clustalopt + view->count_msa_algos, name );
	int stat = menu_props->mode(parts->clustalopt + view->count_msa_algos - 1 );
	menu_props->mode(parts->clustalopt + view->count_msa_algos - 1, stat & ~FL_MENU_DIVIDER );
	menu_props->mode(parts->clustalopt + view->count_msa_algos, FL_MENU_RADIO | FL_MENU_DIVIDER);
	view->alignment_algorithm = view->count_msa_algos;
	((Fl_Menu_Item *)menu_props->menu() + parts->clustalopt + view->alignment_algorithm)->setonly();
	set_algo_option_item(NULL, menu_props, parts->clustalopt + MAX_MSA_ALGOS, FALSE);
	((Fl_Menu_Item *)menu_props->menu() + parts->clustalopt + MAX_MSA_ALGOS + 3)->activate();
	++(view->count_msa_algos);
	sprintf(tmp, "%d", view->count_msa_algos);
	set_res_value("msa_algo_count", tmp);
	sprintf(tmp, "msa_name_%d", view->count_msa_algos);
	set_res_value(tmp, name);
	sprintf(tmp, "msa_args_%d", view->count_msa_algos);
	set_res_value(tmp, args);
	save_resources();
	}
w->hide();
}


void delete_align_callback(Fl_Widget *ob, void *data)
{
props_menu_parts *parts = (props_menu_parts *)data;
SEA_VIEW *view = parts->view;
Fl_Menu_Button *menu_props = (Fl_Menu_Button *)view->bouton_props;
char msa_name[20], *name;
int num, status;

sprintf(msa_name, "msa_name_%d", view->alignment_algorithm + 1);
name = get_res_value(msa_name, NULL);
if(name == NULL) return;
int rep = fl_choice("Delete alignment method  '%s'  ?", "Keep", "Delete", NULL, name);
if(rep == 0) return;
for(num = view->alignment_algorithm + 1; num <= view->count_msa_algos - 1; num++) {
	name = (char *)((Fl_Menu_Item *)menu_props->menu() + parts->clustalopt + num)->label();
	((Fl_Menu_Item *)menu_props->menu() + parts->clustalopt + num - 1)->label(name);
	
	sprintf(msa_name, "msa_name_%d", num + 1);
	name = get_res_value(msa_name, NULL);
	sprintf(msa_name, "msa_name_%d", num);
	set_res_value(msa_name, name);

	sprintf(msa_name, "msa_args_%d", num + 1);
	name = get_res_value(msa_name, NULL);
	sprintf(msa_name, "msa_args_%d", num);
	set_res_value(msa_name, name);
	
	name = get_opt_resname(num);
	name = get_res_value(name, NULL);
	if(name != NULL) {
		strcpy(msa_name, name);
		name = get_opt_resname(num - 1);
		set_res_value(name, msa_name);
		}
	else delete_res_value(get_opt_resname(num - 1));
	}
sprintf(msa_name, "hidden_%d", view->count_msa_algos);
((Fl_Menu_Item *)menu_props->menu() + parts->clustalopt + view->count_msa_algos - 1)->label(msa_name);
status = menu_props->mode(parts->clustalopt + view->count_msa_algos - 1 );
menu_props->mode(parts->clustalopt + view->count_msa_algos - 1, status | FL_MENU_INVISIBLE );
sprintf(msa_name, "msa_name_%d", view->count_msa_algos);
delete_res_value(msa_name);
sprintf(msa_name, "msa_args_%d", view->count_msa_algos);
delete_res_value(msa_name);
name = get_opt_resname(view->count_msa_algos - 1);
delete_res_value(name);
--(view->count_msa_algos);
sprintf(msa_name, "%d", view->count_msa_algos);
set_res_value("msa_algo_count", msa_name);
status = menu_props->mode(parts->clustalopt + view->count_msa_algos - 1 );
menu_props->mode(parts->clustalopt + view->count_msa_algos - 1, status | FL_MENU_DIVIDER );
num = int_res_value("alignment", 1);
view->alignment_algorithm = (num < view->count_msa_algos ? num : 1);
((Fl_Menu_Item *)menu_props->menu() + parts->clustalopt + view->alignment_algorithm)->setonly();
name = get_algo_opts(view->alignment_algorithm, NULL);
set_algo_option_item(name, menu_props, parts->clustalopt + MAX_MSA_ALGOS, FALSE);
num = menu_props->value();
if(view->alignment_algorithm >= 2) ((Fl_Menu_Item *)menu_props->menu() + num)->activate();
else ((Fl_Menu_Item *)menu_props->menu() + num)->deactivate();
save_resources();
}


void choose_align_callback(Fl_Widget *ob, void *data)
{
#ifdef __APPLE__
char *name = MAC_file_chooser("Select external alignment program", NULL, "");
#elif defined(WIN32)
char *name = MG_win32_file_chooser("Select external alignment program", 
	"program (.exe)\0*.exe\0any\0*.*\0", "", NULL, FALSE, NULL);
#else
char *name = fl_file_chooser("Select external alignment program", NULL, "", 0);
#endif
if(name != NULL) {
	((Fl_Input*)data)->value(name);
	((Fl_Input*)data)->position(strlen(name));
	}
}


void add_align_w_callback(Fl_Widget *ob, void *data)
{
static Fl_Window *w = NULL;
static Fl_Input *name, *args;
Fl_Button *chooser;
props_menu_parts *parts = (props_menu_parts *)data;
SEA_VIEW *view = parts->view;
if(view->count_msa_algos >= MAX_MSA_ALGOS) return;
if(w == NULL) {
	w = new Fl_Window(530, 100, "alignment method creation");
	name = new Fl_Input(85, 10, 250, 20, "Name");
	name->tooltip("Enter name of program from PATH"
#ifdef WIN32
	" or seaview's directory"
#endif
	" or select program using button at right");
	args = new Fl_Input(85, 40, 430, 20, "Arguments");
	args->tooltip(
		"probcons example: %f.pir   >   %f.out\n"
		"t_coffee example: %f.pir -outfile=%f.out -output=fasta_aln -outorder=input"
	);
	chooser = new Fl_Button(345, 10, 160, 20, "Select external program");
	chooser->callback(choose_align_callback, (void *)name);
	Fl_Return_Button *b = new Fl_Return_Button(480, 70, 40, 20, "OK");
	b->callback(add_align_callback, data);
	Fl_Button *b2 = new Fl_Button(10, 70, 50, 20, "Cancel");
	b2->callback(add_align_callback, NULL);
	}
name->value(NULL);
args->value(NULL);
name->take_focus();
w->show();
}


void edit_align_callback(Fl_Widget *ob, void *data)
{
props_menu_parts *parts = (props_menu_parts *)data;
SEA_VIEW *view = parts->view;
Fl_Menu_Button *menu_props = (Fl_Menu_Button *)view->bouton_props;
char *opts, *optresname;
char resname[20], name[50];

sprintf(resname, "msa_name_%d", view->alignment_algorithm + 1);
strcpy(name, get_res_value(resname, NULL) );
opts = get_algo_opts(view->alignment_algorithm, &optresname);
opts = (char *)fl_input("Optional arguments for method   '%s'\n"
"(Clustal ex: -gapopen=5 -quicktree | Muscle ex: -maxiters 2 -diags)",
	opts, name);
if(opts == NULL) return;
if(strlen(opts) == 0) opts = NULL;
set_algo_option_item(opts, menu_props, parts->clustalopt + MAX_MSA_ALGOS, TRUE);
if(opts != NULL) set_res_value(optresname, opts);
else delete_res_value(optresname);
save_resources();
}


void align_opt_callback(Fl_Widget *ob, void *data)
{
props_menu_parts *parts = (props_menu_parts *)data;
SEA_VIEW *view = parts->view;
Fl_Menu_Button *menu_props = (Fl_Menu_Button *)ob;
char *opts;

int reponse =  menu_props->value();
if(reponse >= parts->clustalopt && reponse < parts->clustalopt + view->count_msa_algos) { 
	view->alignment_algorithm = reponse - parts->clustalopt;  
	opts = get_algo_opts(view->alignment_algorithm, NULL);
	set_algo_option_item(opts, menu_props, parts->clustalopt + MAX_MSA_ALGOS, FALSE);
	if(view->alignment_algorithm >= 2) ((Fl_Menu_Item *)menu_props->menu() + parts->clustalopt + MAX_MSA_ALGOS + 3)->activate();
	else ((Fl_Menu_Item *)menu_props->menu() + parts->clustalopt + MAX_MSA_ALGOS + 3)->deactivate();
	}
}


char *get_algo_opts(int algonum /* from 0 */, char **presname)
{
char *resname = get_opt_resname(algonum);
if(presname != NULL) *presname = resname;
return get_res_value(resname, NULL);
}


char *get_opt_resname(int algonum)
{
static char resname[20];
sprintf(resname, "msa_opt_args_%d", algonum + 1);
return resname;
}


void set_algo_option_item(char *opts, Fl_Menu_Button *menu, int itemrank, int checkit)
{
int status;

if(opts != NULL && strlen(opts) == 0) opts = NULL;
menu->replace(itemrank, opts == NULL ? "<none>" : opts);
status = FL_MENU_TOGGLE;
if(opts == NULL) status |= FL_MENU_INACTIVE;
else if(checkit) status |= FL_MENU_VALUE;
menu->mode(itemrank, status );
}


void init_msa_algos(void)
{
int count = int_res_value("msa_algo_count", 0);
if(count < 2) {
	set_res_value("msa_algo_count", "2");
	set_res_value("alignment", "1"); /* muscle is default starting msa method */
	set_res_value("msa_name_1", "clustalw"); 
	set_res_value("msa_args_1", "-align -infile=%f.pir -outfile=%f.out -outorder=input -output=fasta");
	set_res_value("msa_name_2", "muscle"); 
	set_res_value("msa_args_2", "-in %f.pir -out %f.out -stable");
	}
}


#if ! ( defined(WIN32) || defined(__APPLE__) )

void change_attr(Fl_Window *w)
{
XSetWindowAttributes attr;
XWindowAttributes current;

XGetWindowAttributes(fl_display, fl_xid(w), &current);
if(current.backing_store != NotUseful) return;
attr.backing_store = WhenMapped;
XChangeWindowAttributes(fl_display, fl_xid(w), CWBackingStore, &attr);
// il faut la redessiner pour que ca fasse effet
w->redraw(); 
Fl::flush();
}

#endif



