#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

// included functions
void *load_resources(char *progname);
char *get_res_value(char *name, char *def_value, void *v_db);
int int_res_value(char *name, int def_value, void *v_db);
int bool_res_value(char *name, int def_value, void *v_db);
int set_res_value(const char *name, const char *value);
int save_resources(void);


#if defined(__APPLE__)

#if TARGET_RT_MAC_MACHO
/* for Mac OS X */
char *get_res_value(char *name, char *def_value, void *unused)
{
OSStatus err;
CFStringRef cfname;
CFPropertyListRef cfvalue;
static char value[100];

cfname = CFStringCreateWithCString(kCFAllocatorDefault, name, kCFStringEncodingASCII);
cfvalue = CFPreferencesCopyAppValue(cfname, kCFPreferencesCurrentApplication);
if(cfvalue == NULL) return def_value;
CFStringGetCString( (CFStringRef)cfvalue, value, sizeof(value), kCFStringEncodingASCII);
CFRelease(cfname); CFRelease(cfvalue);
return value;
}


int set_res_value(const char *name, const char *value)
{
char *p;
CFStringRef cfname, cfvalue;

cfname = CFStringCreateWithCString(kCFAllocatorDefault, name, kCFStringEncodingASCII);
cfvalue = CFStringCreateWithCString(kCFAllocatorDefault, value, kCFStringEncodingASCII);
CFPreferencesSetAppValue(cfname, cfvalue, kCFPreferencesCurrentApplication);
CFPreferencesAppSynchronize(kCFPreferencesCurrentApplication);
CFRelease(cfname); CFRelease(cfvalue);
return 0;
}

#else
/* for Classic MaCOS */
extern "C" {
extern void PtoC(const void *in, void *out);
extern void CtoP(const void *in, void *out);
}

static char *load1res(char *resname)
{
	char **h, *p, pname[256]; 
	int l;

	CtoP(resname, pname);
	h = GetNamedResource('TEXT', (ConstStr255Param)pname );
	if(h == NULL) return NULL;
	else	{
		l = GetHandleSize(h);
		p = (char *)malloc(l + 1);
		}
	if(p != NULL) {
		HLock(h);
		memcpy(p, *h, l);
		HUnlock(h);
		p[l] = 0;
		if(p[--l] == '\r') p[l] = 0;
		}
	ReleaseResource(h);
	return p;
}
	
char *get_res_value(char *name, char *def_value, void *v_db)
{
char *p;

p = load1res(name);
if(p != NULL) return p;
else return def_value;
}


int set_res_value(const char *name, const char *value)
/* returns 0 iff no error */
{
Str255 pname;
Handle h;
short id;
OSErr err;
int l;

CtoP(name, pname);
l = strlen(value);
h = GetNamedResource('TEXT', pname);
if(h == NULL) { // resource not yet exists
	if(ResError() != resNotFound) return 1;
	id = Unique1ID('TEXT');
	h = NewHandle(l);
	if(h == NULL) return 1;
	HLock(h);
	memcpy(*h, value, l);
	HUnlock(h);
	AddResource(h, 'TEXT', id, pname);
	if( ResError() != noErr) return 1;
	}
else {// resource already exists
	if(l == GetHandleSize(h)) {
		HLock(h);
		err = memcmp(*h, value, l);
		HUnlock(h);
		if(err == 0) return 0; // same value already, stop here
		}
	SetHandleSize(h, l);
	if( MemError() != noErr) return 1;
	HLock(h);
	memcpy(*h, value, l);
	HUnlock(h);
	ChangedResource(h);
	if( ResError() != noErr) return 1;
	}
ReleaseResource(h);
err = ResError();
return err != noErr ;
}

#endif

int save_resources(void)
{ // nothing to do, taken care of by the system
}

void *load_resources(char *progname)
{ // nothing to do, taken care of by the system
return NULL;	
}


#else /* for X11 and win32 */

typedef struct _item {
	struct _item *before;
	char *name;
	char *value;
	struct _item *next;
	} item;

static item *firstitem = NULL;

extern "C" { 
	char *get_prog_dir(void); 
	}

char *res_filename(void)
{
static char fname[FILENAME_MAX];
char *p;

#ifdef WIN32
p = get_prog_dir();
if(p == NULL) return NULL;
strcpy(fname, p);
strcat(fname, "\\seaview.ini");
#else
p = getenv("HOME");
if(p == NULL) return NULL;
strcpy(fname, p);
strcat(fname, "/.seaviewrc");
#endif
return fname;
}


void *load_resources(char *progname)
{
FILE *in;
char *fname, *p, line[500];
item *elt, *last = NULL;

fname = res_filename();
if(fname == NULL) return NULL;
in = fopen(fname, "r");
if(in == NULL) return NULL;
while((p = fgets(line, sizeof(line), in)) != NULL) {
	p = strchr(line, '\n'); if(p != NULL) *p = 0;
	p = strchr(line, '=');
	if(p == NULL) continue;
	*(p++) = 0; while(isspace(*p))  p++;
	if(*p == 0) continue;
	elt = (item *)malloc(sizeof(item));
	if(elt == NULL) break;
	elt->name = strdup(line);
	elt->value = strdup(p);
	if(elt->name == NULL || elt->value == NULL) break;
	if(last != NULL) last->next = elt;
	else firstitem = elt;
	elt->before = last;
	last = elt;
	elt->next = NULL;
	}
fclose(in);
return firstitem;
}


char *get_res_value(char *name, char *def_value, void *v_db)
{
if(v_db == NULL) return def_value;
item *elt = (item *)v_db;

while(elt != NULL) {
	if(strcmp(name, elt->name) == 0) return elt->value;
	elt = elt->next;
	}
return def_value;
}


int set_res_value(const char *name, const char *value)
{
item *elt, *last = NULL;

elt = firstitem;
while(elt != NULL) {
	if(strcmp(elt->name, name) == 0) {
		free(elt->value);
		elt->value = strdup(value);
		return 0;
		}
	last = elt;
	elt = elt->next;
	}
elt = (item *)malloc(sizeof(item));
if(elt == NULL) return 1;
elt->name = strdup(name);
elt->value = strdup(value);
if(elt->name == NULL || elt->value == NULL) return 1;
if(last != NULL) last->next = elt;
else firstitem = elt;
elt->before = last;
elt->next = NULL;
return 0;
}


int save_resources(void)
{ 
char *fname;
item *elt;
FILE *out;

fname = res_filename();
if(fname == NULL) return 1;
out = fopen(fname, "w");
if(out == NULL) return 1;
elt = firstitem;
while(elt != NULL) {
	fprintf(out, "%s=%s\n", elt->name, elt->value);
	elt = elt->next;
	}
fclose(out);
return 0;
}

#endif


int int_res_value(char *name, int def_value, void *v_db)
{
int val = def_value;
char *p = get_res_value(name, NULL, v_db);
if( p != NULL ) sscanf(p, "%d", &val);
return val;
}


int bool_res_value(char *name, int def_value, void *v_db)
{
char *p = get_res_value(name, NULL, v_db);
if( p == NULL ) return def_value;
return (*p == 'T' || *p == 't');
}

