/*
 *  Part of the shrinkta program, a dvd backup tool
 *
 *  Copyright (C) 2005  Daryl Gray
 *  E-Mail Daryl Gray darylgray1@dodo.com.au
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
*/
/** $Revision: 1.01 $
 * Libdvd common header
 * @file dvd-decoder.h Dvd object header file
 * @ingroup core
 *
 * libdvd
 */

#if !defined (__DVD_H_INSIDE__) && !defined (LIBDVD_COMPILATION)
#error "Only <dvd.h> can be included directly."
#endif

#ifndef __DVD_DECODER_AC3_H__
#define __DVD_DECODER_AC3_H__


G_BEGIN_DECLS


/* --- type macros --- */
#define DVD_DECODER_AC3_TYPE		(dvd_decoder_ac3_get_type())
#define DVD_DECODER_AC3(o)		(G_TYPE_CHECK_INSTANCE_CAST (o, DVD_DECODER_AC3_TYPE, DvdDecoderAc3))
#define DVD_DECODER_AC3_CLASS(k)	(G_TYPE_CHECK_CLASS_CAST    (k, DVD_DECODER_AC3_TYPE, DvdDecoderAc3Class))
#define DVD_IS_DVD_DECODER_AC3(o)	(G_TYPE_CHECK_INSTANCE_TYPE (o, DVD_DECODER_AC3_TYPE))
#define DVD_IS_DVD_DECODER_AC3_CLASS(k)	(G_TYPE_CHECK_CLASS_TYPE    (k, DVD_DECODER_AC3_TYPE))

/* --- typedefs & structures --- */
typedef struct	_DvdDecoderAc3		DvdDecoderAc3;
typedef struct	_DvdDecoderAc3Class	DvdDecoderAc3Class;
typedef struct	_DvdAc3BSHeader		DvdAc3BSHeader;
typedef struct	_DvdAc3SyncHeader	DvdAc3SyncHeader;
typedef enum	_DvdAc3SampleRate	DvdAc3SampleRate;

/* Ac3 audio sample rate - dvd must always be 48000 */
enum _DvdAc3SampleRate {
	DVD_AC3_SAMPLERATE_48000 = 0,
	DVD_AC3_SAMPLERATE_44100 = 1,
	DVD_AC3_SAMPLERATE_32000 = 2,
	DVD_AC3_SAMPLERATE_RES   = 3
};

/* Ac3 stream synchronization header */
struct _DvdAc3SyncHeader {
	guint16	sync_word;
	guint16 crc1;
	guint	samplerate_code : 2;	/* DvdAc3SampleRate */
	guint	framesize_code  : 6;
};

/* Ac3 bit stream header */
struct _DvdAc3BSHeader {
	guint32	id		: 5;	/* id always 01000?? */
	guint	bsmode		: 3;	/* bitsream mode */
	guint	acmode		: 3;	/* Audio coding mode */
	guint	cmixlevel	: 2;	/* Center mix level */
	guint	surmixlevel	: 2;	/* Surround mix level */
	guint	dsurmode	: 2;	/* Dolby surround mode */
	guint	lfeon		: 1;	/* Low frequency effects channel on */
	guint	dialnorm	: 5;	/* Dialogue normalization */
	guint	compre		: 1;	/* Compression gain word exists */
	guint8	compr;			/* Compression gain word [only if compre = 1] */
	guint	langcode	: 1;	/* Language code exists */
	guint8	langcod;		/* language code reserved [only if langcode = 1] */
	guint	audprodie	: 1;	/* Audio production information exists */
	guint	mixlevel	: 5;	/* Mixing level [0nly if audprodie = 1] */
	guint	roomtype	: 2;	/* Room type [0nly if audprodie = 1] */
	guint	dialnorm2	: 5;	/* Dialogue normalization, ch2 */
	guint	compre2		: 1;	/* Compression gain word exists */
	guint8	compr2;			/* Compression gain word, ch2  [only if compr2e = 1] */
	guint	langcode2	: 1;	/* Language code exists, ch2 */
	guint8	langcod2;		/* Language code, ch2 [only if langcode2 = 1] */
	guint	audprodie2	: 1;	/* Audio production information exists, ch2 */
	guint	mixlevel2	: 5;	/* Mixing level, ch2 [ only if audprodi2e = 1] */
	guint	roomtype2	: 2;	/* Room type, ch2 [ only if audprodi2e = 1] */
	guint	copyright	: 1;	/* Copyright bit */
	guint	original	: 1;	/* Original bit stream */
	/* timecode: Time code (first and second) halves exist, 2 bits */
	/* timecod1: Time code first half, 14 bits */
	/* timecod2: Time code second, 14 bits half */
	/* addbsie: Additional bit stream information exists, 1 bit */
	/* addbsil: Additional bit stream information length, 6 bits */
	/* addbsi: Additional bit stream information, [(addbsil+1) × 8] bits */
};

typedef enum {
	DVD_DECODER_AC3_STATE_SEEK_START,	/* seeking to start code */
	DVD_DECODER_AC3_STATE_SYNC_HDR,		/* reading sync header */
	DVD_DECODER_AC3_STATE_BSI_HDR,		/* reading bsi header */
	DVD_DECODER_AC3_STATE_STREAM,		/* reading rest of frame */
	DVD_DECODER_AC3_STATE_ERROR		/* encountered bitstream error */
} DvdDecoderAC3State;

struct _DvdDecoderAc3 {
	DvdDecoder	 parent;
	
	DvdAc3SyncHeader sync_hdr;
	DvdAc3BSHeader	 bs_hdr;
	DvdDecoderAC3State	state;
	guint8		 syncframe_byte;
	guint32		 clocks_per_frame;
	guint16		 bytes_per_frame;
	
	/* for reading bitstream headers 1 byte at a time */
	guint		 header_byte;		/* byte starting from zero of header being read */
	guint		 header_variable;	/* header variable being read  - usually enumeration is used */
	guint8		 data_bit;		/* from most significant bit (0) */
	guint32		 variable_uint;		/* header variable edited */
	guint		 variable_bit;		/* bits already read into variable */
};


struct _DvdDecoderAc3Class {
	DvdDecoderClass	parent;
};

/* --- prototypes --- */
GType		dvd_decoder_ac3_get_type		(void);

G_END_DECLS

#endif /*__DVD_DECODER_AC3_H__*/
