/*
 *  Part of the shrinkta program, a dvd backup tool
 *
 *  Copyright (C) 2005  Daryl Gray
 *  E-Mail Daryl Gray darylgray1@dodo.com.au
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
*/

#if !defined (__DVD_H_INSIDE__) && !defined (LIBDVD_COMPILATION)
#error "Only <dvd.h> can be included directly."
#endif

#ifndef __DVD_DECODER_M2V_H__
#define __DVD_DECODER_M2V_H__


G_BEGIN_DECLS


/* --- type macros --- */
#define DVD_DECODER_M2V_TYPE		(dvd_decoder_m2v_get_type())
#define DVD_DECODER_M2V(o)		(G_TYPE_CHECK_INSTANCE_CAST (o, DVD_DECODER_M2V_TYPE, DvdDecoderM2v))
#define DVD_DECODER_M2V_CLASS(k)	(G_TYPE_CHECK_CLASS_CAST    (k, DVD_DECODER_M2V_TYPE, DvdDecoderM2vClass))
#define DVD_IS_DVD_DECODER_M2V(o)	(G_TYPE_CHECK_INSTANCE_TYPE (o, DVD_DECODER_M2V_TYPE))
#define DVD_IS_DVD_DECODER_M2V_CLASS(k)	(G_TYPE_CHECK_CLASS_TYPE    (k, DVD_DECODER_M2V_TYPE))

/* --- typedefs & structures --- */
typedef struct	_DvdDecoderM2v		DvdDecoderM2v;
typedef struct	_DvdDecoderM2vClass	DvdDecoderM2vClass;
typedef struct	_DvdM2vSequenceHdr	DvdM2vSequenceHdr;
typedef struct	_DvdM2vSequenceHdrExt	DvdM2vSequenceHdrExt;
typedef struct	_DvdM2vSequenceDispHdr	DvdM2vSequenceDispHdr;

typedef struct	_DvdM2vGOPTime		DvdM2vGOPTime;
typedef struct	_DvdM2vGOPHdr		DvdM2vGOPHdr;
typedef enum	_DvdM2vPictureCoding	DvdM2vPictureCoding;
typedef struct	_DvdM2vPictureHdr	DvdM2vPictureHdr;
typedef struct	_DvdM2vPictureCodingHdr	DvdM2vPictureCodingHdr;
typedef struct	_DvdM2vPicture		DvdM2vPicture;
typedef struct	_DvdM2vSequence		DvdM2vSequence;

/* All start codes followed by 3 zero bytes */
/* ensuring the byte aligned combinations don't */
/* occur anywhere else in the bit stream */
typedef enum {
	/* video start codes */
	DVD_M2V_START_CODE_PICTURE	= 0x00,
	DVD_M2V_START_CODE_SLICE_FIRST	= 0x01, /* 176x 0x01 to 0xaf */
	DVD_M2V_START_CODE_SLICE_LAST	= 0xaf,
	DVD_M2V_START_CODE_USER_DATA	= 0xb2,
	DVD_M2V_START_CODE_SEQUENCE_HDR	= 0xb3,
	DVD_M2V_START_CODE_SEQUENCE_ERR	= 0xb4,
	DVD_M2V_START_CODE_EXTENSION	= 0xb5,
	DVD_M2V_START_CODE_SEQUENCE_END	= 0xb7,
	DVD_M2V_START_CODE_GROUP_OF_PIC	= 0xb8
} DvdM2vStartCode;

/* extension header ID codes are first 4 bits */
/* following DVD_M2V_START_CODE_EXTENSION */
typedef enum {
	/* 0x00 reserved*/
	DVD_M2V_EXT_ID_SEQUENCE		= 0x1,
	DVD_M2V_EXT_ID_SEQUENCE_DISPLAY	= 0x2,
	DVD_M2V_EXT_ID_QUANT_MATRIX	= 0x3,
	DVD_M2V_EXT_ID_COPYRIGHT	= 0x4,
	DVD_M2V_EXT_ID_SEQUENCE_SCALABLE= 0x5,
	/* 0x6 reserved*/
	DVD_M2V_EXT_ID_PICTURE_DISPLAY	= 0x7,
	DVD_M2V_EXT_ID_PICTURE_CODING	= 0x8,
	DVD_M2V_EXT_ID_PICTURE_SPATIAL	= 0x9,
	DVD_M2V_EXT_ID_PICTURE_TEMPORAL	= 0xa,
	/* 0xb to 0xf reserved*/
} DvdM2vExtID;

/* Sequence header 12 bytes long + 64 if load_iq_matrix=1 + 64 if load_niq_matrix=1 */
struct _DvdM2vSequenceHdr {
	/* 0x000001 */
	/* DVD_M2V_START_CODE_SEQUENCE_HDR */
	guint	horizontal_size	: 12;
	guint	vertical_size	: 12;
	guint	aspect		: 4;
	guint	frame_rate_code	: 4;
	guint	bit_rate	: 18;
	/* 1 marker bit */
	guint	vbv_buffer_size	: 10;
	guint	cp_flag		: 1; /* Constrained parameters flag */
	guint	load_iq_matrix	: 1;
	guint8	iq_matrix[64];
	guint	load_niq_matrix	: 1;
	guint8	niq_matrix[64];
	/* MPEG2 always followed by DvdM2vSequenceHdrExt else MPEG1 stream */
};

/* Sequence extension header 10 bytes long */
struct _DvdM2vSequenceHdrExt {
	/* 0x000001 */
	/* DVD_M2V_START_CODE_EXTENSION */
	/* 0001 - 4 bit extension_id */
	guint	pl_indication	     : 8;	/* profile_and_level_indication */
	guint	progressive_sequence : 1;
	guint	chroma_format	     : 2;
	guint	horizontal_size_ext  : 2;
	guint	vertical_size_ext    : 2;
	guint	bit_rate_extension   : 12;
	/* 1 marker_bit */
	guint	vbv_buffer_size_ext  : 8;
	guint	low_delay	     : 1;
	guint	frame_rate_ext_n     : 2;
	guint	frame_rate_ext_d     : 5;
	/* next_start_code () */
};

/* 5 bytes, 8 if colour_description > 0 */
struct _DvdM2vSequenceDispHdr {
	/* 0x000001 */
	/* DVD_M2V_START_CODE_EXTENSION */
	/* 0010 - 4 bit extension_id */
	guint	video_format	        : 3;
	guint	colour_description      : 1;
	guint8	colour_primaries;		/* if (colour_description) */
	guint8	transfer_characteristics;	/* if (colour_description) */
	guint8	matrix_coefficients;		/* if (colour_description) */
	guint	display_horizontal_size : 14;
	/* marker_bit */
	guint	display_vertical_size   : 14;
	/* 3 unused bits */
	/* next_start_code () */
};

/* 3 bytes, 1 bit long */
struct _DvdM2vGOPTime {
	guint	drop_frame	: 1;
	guint	hours		: 5;	/* 0 - 23 */
	guint	minutes		: 6;	/* 0 - 59 */
	/* 1 marker_bit */
	guint	seconds		: 6;	/* 0 - 59 */
	guint	pictures	: 6;	/* 0 - 59 */
};

/* mpeg video group of pictures header */
/* .time is first picture after the GOP header */
/* that has temporal_reference 0 (following I frame) */
/* 8 bytes including 5 unused bits */
/* NOTE: I have found that if the last header byte is 0, it may be included in */
/* the next start code */
struct _DvdM2vGOPHdr {
	/* 0x000001 */
	/* DVD_M2V_START_CODE_GROUP_OF_PIC */
	DvdM2vGOPTime	time;		 /* not used during decoding (useful for video editing software?) */
	guint		closed_gop  : 1; /* if 1, following B pictures have been encoded */
					 /* using only backward prediction or intra coding */
					 /* (following frames can be displayed without previous stream frames) */
	guint		broken_link : 1; /* When splitting a stream, set broken_link in first gop to 1 if closed_gop = 0 */
					 /* so the incomplete frames are not displayed */
	/* 5 unused bits */
	/* next_start_code () */
};

enum _DvdM2vPictureCoding {
	DVD_M2V_PICTURE_CODING_I,	/* intra (whole picture) */
	DVD_M2V_PICTURE_CODING_P,	/* predictive (requires previous picture) */
	DVD_M2V_PICTURE_CODING_B	/* bidirectionally predictive (requires previous and following picture)*/
};

struct _DvdM2vPictureHdr {
	guint16			temporal_reference;	/* 10 bit uint */
	DvdM2vPictureCoding	coding;			/* picture coding type is 3 bit uint */
	guint16			vbv_delay;		/* 16 bit uint */
	
	/* **NOTE** the rest of header is either unused in MPEG2 or reserved for */
	/* future specifications (Should not be present and ignored by decoder if so) */
	
	/* junk */
	/* next_start_code () */
};

struct _DvdM2vPictureCodingHdr {
	/* 0x000001 */
	/* DVD_M2V_START_CODE_EXTENSION */
	/* 1000 - 4 bit extension_id */
	guint	forward_horizontal		: 4; /* f_code[0][0] */
	guint	forward_vertical		: 4; /* f_code[0][1] */
	guint	backward_horizontal		: 4; /* f_code[1][0] */
	guint	backward_vertical		: 4; /* f_code[1][1] */
	guint	intra_dc_precision		: 2;
	guint	picture_structure		: 2; /* 00 reserved, 01 Top Field, 10 Bottom Field, 11 Frame picture */

	guint	top_field_first			: 1;
	guint	frame_pred_frame_dct		: 1;
	guint	concealment_motion_vectors	: 1;
	guint	q_scale_type			: 1;
	guint	intra_vlc_format		: 1;
	guint	alternate_scan			: 1;
	guint	repeat_first_field		: 1;
	guint	chroma_420_type			: 1;
	guint	progressive_frame		: 1;
	guint	composite_display_flag		: 1;
	/* if ( composite_display_flag ) { */
	guint	v_axis				: 1;
	guint	field_sequence			: 3;
	guint	sub_carrier			: 1;
	guint	burst_amplitude			: 7;
	guint	sub_carrier_phase		: 8;
	/* } */
	/* next_start_code() */
};


struct _DvdM2vPicture {
	DvdM2vPictureHdr    header;
	DvdM2vPictureCodingHdr coding_header;
	guint		    length;	/* length of picture from start of picture header start code till end of data */
	guint		    offset;	/* byte offset of picture header start code from start of sequence header start code */
	
};

/* Only the useful information about the sequence derived from */
/* DvdM2vSequenceHdr */
/* DvdM2vSequenceHdrExt */
/* DvdM2vGOPHdr */
struct _DvdM2vSequence {
	/*guint		 length;
	guint		 gop_offset;*/
	
	guint16		 horizontal_size;
	guint16		 vertical_size;
	guint64		 bit_rate;		/* bits per second */
	guint32		 vbv_buffer_size;	/* minimum buffer size in bits */
	
	guint		 picture_count;
	guint		 frame_count;
	guint64		 clocks;		/* 27000000/s clock */
	/*DvdM2vPicture	*picture;*/
};

typedef enum {
	DVD_DECODER_M2V_STATE_SEEK_START,	/* seeking to start code */
	DVD_DECODER_M2V_STATE_SEEK_SEQ,		/* seeking to sequence start code */
	DVD_DECODER_M2V_STATE_SEQ_HDR,
	DVD_DECODER_M2V_STATE_SEQ_EXT_HDR,
	DVD_DECODER_M2V_STATE_EXTENSIONS_0,	/* extension_and_user_data(0) */
	DVD_DECODER_M2V_STATE_SEQUENCE_DISPLAY,
	DVD_DECODER_M2V_STATE_SEQUENCE_SCALABLE,
	DVD_DECODER_M2V_STATE_GOP_HDR,
	DVD_DECODER_M2V_STATE_EXTENSIONS_1,	/* only_user_data(1) */
	DVD_DECODER_M2V_STATE_PIC_HDR,
	DVD_DECODER_M2V_STATE_PIC_CODING_EXT,
	DVD_DECODER_M2V_STATE_EXTENSIONS_2,	/* extension_and_user_data(2) */
	DVD_DECODER_M2V_STATE_PICTURE_DATA,
	DVD_DECODER_M2V_STATE_SEQ_END,
	/* error states */
	DVD_DECODER_M2V_STATE_MPEG1,		/* no sequence header extension */
	DVD_DECODER_M2V_STATE_ERROR		/* encountered bitstream error */
} DvdDecoderM2vState;

struct _DvdDecoderM2v {
	DvdDecoder	      parent;

	/*--- public - inspect on decoder::output_frame signal OK ---*/
	DvdM2vSequence	      sequence;
	
	/*--- private ---*/
	/* True if the first sequence header (discard sequence if not followed by GOP) */
	gboolean	      first_sequence;
	
	/* headers of first sequence with a GOP header */
	DvdM2vSequenceHdr     seqence_header;
	DvdM2vSequenceHdrExt  seqence_header_extension;
	DvdM2vSequenceDispHdr seqence_display_header;
	
	/* header of GOP following sequence header if any */
	DvdM2vGOPHdr	      gop_header;
	
	DvdDecoderM2vState    state;
	DvdDecoderM2vState    next_state;
	
	/* ext_id only valid when state is DVD_DECODER_M2V_STATE_EXTENSIONS_X */
	DvdM2vExtID	      ext_id;
	
	guint32		      clocks_per_picture;	/* 27000000/s clock */
	
	/* byte starting from zero of header being read */
	/* not including any DvdM2vStartCode but including DvdM2vExtID */
	/* if an extension header is being read */
	guint		      header_byte;
	
	/* set to true by dvd_decoder_m2v_find_start_code () if */
	/* a 0x000001 sequence is found and then sets zero_bytes to 0 */
	gboolean	      start_found;
	
	/* used by dvd_decoder_m2v_find_start_code () to */
	/* keep track of contiguous zero bytes */
	/* This value may be reduced to no less than 2 by other functions */
	/* if this is desired */
	/*guint8		      zero_bytes;*/
	guint16		      zero_bytes;
};


struct _DvdDecoderM2vClass {
	DvdDecoderClass	parent;
};

/* --- prototypes --- */
GType		dvd_decoder_m2v_get_type		(void);

G_END_DECLS

#endif /*__DVD_DECODER_M2V_H__*/
