/*
 *  Part of the shrinkta program, a dvd backup tool
 *
 *  Copyright (C) 2005  Daryl Gray
 *  E-Mail Daryl Gray darylgray1@dodo.com.au
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
*/
#include <inttypes.h>
#include <config.h>
#include <glib-object.h>
#include <glib/gi18n.h>

#include "dvd.h"

GQuark
dvd_error_quark		(void)
{
	static GQuark dvd_error_quark = 0;
	static const gchar *DVD_QUARK_STRING = "dvd_error_domain";
	static GStaticMutex mutex = G_STATIC_MUTEX_INIT;
	GQuark ret_quark;

	g_static_mutex_lock (&mutex);
	if (dvd_error_quark == 0) {
		dvd_error_quark = g_quark_from_static_string (DVD_QUARK_STRING);
	}
	ret_quark = dvd_error_quark;
	g_static_mutex_unlock (&mutex);
	return ret_quark;
}
