/*
 *  Part of the shrinkta program, a dvd copy tool
 *
 *  Copyright (C) 2005  Daryl Gray
 *  E-Mail Daryl Gray darylgray1@dodo.com.au
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <libgnomevfs/gnome-vfs.h>
#include <gnome.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <fcntl.h>
#include <errno.h>
#include <signal.h>
#include <errno.h>

#include <dvd.h>
#include "preferences.h"
#include "preferences-dialog.h"
#include "app.h"

gchar *cldrive;

/* command line argument parsing structure */
static struct poptOption options[] =
{
	{"dvd", 'd', POPT_ARG_STRING, &cldrive, 0,
		N_("Path to DVD drive"), NULL},
	{NULL, 0, 0, NULL, 0, NULL, NULL}
};

int
main		(int	 argc,
		 char	*argv[])
{
	
#ifdef ENABLE_NLS
	bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
#endif
	g_thread_init (NULL);
	g_type_init ();
	gdk_threads_init ();
	gnome_program_init (GETTEXT_PACKAGE, VERSION, LIBGNOMEUI_MODULE,
			    argc, argv,
			    GNOME_PARAM_APP_DATADIR, PACKAGE_DATA_DIR,
			    GNOME_PARAM_POPT_TABLE, options,
			    NULL);
	if (gnome_vfs_init () == FALSE) {
		g_error ("Could not initialize GnomeVFS");
		return 1;
	}
	preferences = preferences_new ();
	if (preferences == NULL) {
		g_error ("prefs_init failed");
	}
	create_app ();
	
	if (cldrive != NULL) {
		if (g_file_test (cldrive, G_FILE_TEST_EXISTS) == FALSE) {
			g_warning ("%s does not exist!", cldrive);
		} else {
			set_drive_path (cldrive);
		}
		g_free (cldrive);
	}
	gtk_main ();
	g_object_unref (G_OBJECT (preferences));
	return 0;
}
