# coding: utf-8
=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download
 * Description: Skin prepared for Free Culture, Lawrence Lessig
 * arch-tag: skin for an individual document set (lessig - freeculture)
 * License: Same as SiSU see http://www.jus.uio.no/sisu
 * $Date$
 * $Id$
 * Notes: Site default appearance variables set in defaults.rb
     Generic site wide modifications set here scribe_skin.rb, and this file required by other "scribes" instead of defaults.rb
=end
module SiSU_Viz
  require SiSU_lib + '/defaults'
  class Skin
    #def path_root                                                                     # the only parameter that cannot be changed here
    #  './sisu/'
    #end
    #def path_rel
    #  '../'
    #end
    #def url_hp # used by wmap, get rid of ie make it seek home instead
    #  'http://www.free-culture.cc/'
    #end
    def url_home
      'http://www.free-culture.cc'
    end
    def url_txt                                                                      # text to go with url usually stripped url
      'www.lessig.org'
    end
    #def url_root_http
      #root server path info, used in document information
    #end
    def color_band1
      '"#000000"'
    end
    def txt_hp
      'www.lessig.org'
    end
    def txt_home
      'Lawrence Lessig'
    end
    def icon_home_button
      'freeculture.home.png'
    end
    def icon_home_banner
      icon_home_button
    end
    def banner_home_button
      %{<table summary="home button" border="0" cellpadding="3" cellspacing="0"><tr><td align="left" bgcolor=#{color_black}><a href="#{url_home}">#{png_home}</a></td></tr></table>\n}
    end
    def banner_home_and_index_buttons
      %{<table><tr><td width="20%"><table summary="home and index buttons" border="0" cellpadding="3" cellspacing="0"><tr><td align="left" bgcolor=#{color_black}><a href="#{url_home}" target="_top">#{png_home}</a></td><td width="40%"><center><table summary="buttons" border="1" cellpadding="3" cellspacing="0"><tr><td align="center" bgcolor="#f1e8de"><font face="arial" size="2"><a href="toc.html" target="_top">&nbsp;This&nbsp;text&nbsp;sub-&nbsp;<br />&nbsp;Table&nbsp;of&nbsp;Contents&nbsp;</a></font>#{table_close}</center></td><td width="20%">&nbsp;#{table_close}}
    end
    def banner_band
      %{<table summary="band" border="0" cellpadding="3" cellspacing="0"><tr><td align="left" bgcolor=#{color_black}><a href="#{url_home}" target="_top">#{png_home}</a>#{table_close}}
    end
    def credits_splash
      %{<table summary="credits" align="center" bgcolor="#ffffff"><tr><td><font color="black"><center><img border="0" align="center" src="../_sisu/image_local/freeculture_bcode.png" alt="Free Culture Bar Code"><br />Available at Amazon.com<br /><a href="http://www.amazon.com/exec/obidos/tg/detail/-/1594200068/"><img border="0" align="center" src="../_sisu/image_local/freeculture_book.png" alt="Free Culture at Amazon.com"></a><br />This book is Copyright Lawrence Lessig © 2004<br />Under a Creative Commons License, that permits non-commercial use of this work, provided attribution is given.<br />See <a href="http://www.free-culture.cc/">http://www.free-culture.cc/</a><br /><a href="mailto://lessig@pobox.com">lessig@pobox.com</a></center></font></td></tr></table>}
    end
  end
  class TeX
    def header_center
	    "\\chead{\\href{#{@vz.url_home}}{lessig.org}}"
    end
    def home_url
	    "\\href{#{@vz.url_home}}{lessig.org}"
    end
    def home
	    "\\href{#{@vz.url_home}}{Lawrence Lessig}"
    end
    def owner_chapter
      "Document owner details"
    end
  end
end
