import gtk
import gobject
import sys
import re
import string
import time

#Skype4Py
import Skype4Py

# for debugging
import pdb

REV="$Rev: 76 $"

class SendSMS:
	def __init__(self, skype_obj, friends):
		# Initialize vars
		self.mysms = False
		self.sms_sent = False
		self.friends = friends

		self.skype = skype_obj
		self.skype.RegisterEventHandler('Notify', self.SkypeEvents)

	def SkypeEvents(self, arg):
		if not self.mysms:
			return

		# Send SMS Handling
		re_sms = re.match('^SMS '+str(self.mysms.Id)+' (.*)$', arg)
		if re_sms:
			price =  float(self.mysms.Price) / \
				(10**float(self.mysms.PricePrecision))

			s=""
			count = 0
			last = len(self.mysms.Targets)
			acceptable = False
			for target in self.mysms.Targets:
				s += target.Number+": "
				s += self.skype.Convert.SmsTargetStatusToText(target.Status)
				if target.Status == "TARGET_ACCEPTABLE":
					acceptable = True
				count += 1
				if count < last:
					s += "\n"

			gtk.gdk.threads_enter()
			self.l_price.set_text(self.mysms.PriceCurrency+" "+str(price))
			self.l_status.set_text(self.skype.Convert.SmsMessageStatusToText(
				self.mysms.Status))
			self.l_target.set_text(s)
			self.l_replyto.set_text(self.mysms.ReplyToNumber)

			# Enable Messagebox, if at least one Target is acceptable
			if acceptable and not self.sms_sent:
				self.textbuffer.set_text('')
				self.textview.set_editable(True)
				self.textview.grab_focus()
				self.sendbutton.set_label("Send SMS")
				self.sendbutton.disconnect(self.sendbutton_connect)
				self.sendbutton_connect = self.sendbutton.connect("clicked",
					self.send_sms)

			gtk.gdk.threads_leave()
	
	def send_sms(self, widget):
		startiter = self.textbuffer.get_start_iter()
		enditer = self.textbuffer.get_end_iter()
		text = self.textbuffer.get_text(startiter, enditer)
		if text == "":
			return

		self.mysms.Body = text

		self.sms_sent = True
		self.mysms.Send()

		self.textview.set_editable(False)
		self.sendbutton.set_label("Clear SMS")
		self.sendbutton.disconnect(self.sendbutton_connect)
		self.sendbutton_connect = self.sendbutton.connect("clicked",
			self.clear_sms)

	def clear_sms(self, widget):
		self.sendbutton.set_label("Check Number")
		self.sendbutton.disconnect(self.sendbutton_connect)
		self.sendbutton_connect = self.sendbutton.connect("clicked",
			self.check_number, self.entry)
		self.mysms = False

		# Reset SMS
		self.l_price.set_text('')
		self.l_status.set_text('')
		self.l_target.set_text('')
		self.l_replyto.set_text('')
		s = "Enter a phonenumber and click 'Check Number'.\n"
		s += "If the number is accepted, you can enter the text here."
		self.textbuffer.set_text(s)
		self.charcount.set_text('')
		self.sms_sent = False

	def clean_number(phone):
		phone = phone.replace(" ", "")
		phone = phone.replace("(", "")
		phone = phone.replace(")", "")
		phone = phone.replace("-", "")
		return phone
	clean_number = staticmethod(clean_number)

	def check_number(self, widget, entry):
		iter = self.entry.get_active_iter()
		if iter:
			number = self.entry_ls.get_value(iter, 1)
		else:
			number = entry.child.get_text()
		if number == "":
			return
		number = SendSMS.clean_number(number)
		self.mysms = self.skype.CreateSms('OUTGOING', number)

	def changed_entry(self, entry):
		self.clear_sms(entry)
	
	def update_text_char(self, widget):
		char_count = self.textbuffer.get_char_count()
		self.charcount.set_text("Length: "+str(char_count))

	def window_send_sms(self):
		vbox = gtk.VBox(False, 0)

		label = gtk.Label("Send SMS")
		label.set_markup("<span size=\"large\" weight=\"bold\">Send SMS</span>") 
		vbox.pack_start(label, False, False, 0)
		label.show()

		frame = gtk.Frame('Phone Number:')
		hbox = gtk.HBox(False, 0)

		self.entry_ls = gtk.ListStore(str, str)
		self.entry = gtk.ComboBoxEntry(self.entry_ls, 0)

		friends = self.friends.keys()
		friends.sort()
		for friend in friends:
			self.entry_ls.append([friend, self.friends[friend]])
		self.entry.child.connect('changed', self.changed_entry)
		hbox.pack_start(self.entry, False, False, 0)
		self.entry.show()
		self.entry.grab_focus()

		self.sendbutton = gtk.Button("Check Number")
		self.sendbutton_connect = self.sendbutton.connect("clicked",
			self.check_number, self.entry)
		self.sendbutton.set_flags(gtk.CAN_DEFAULT)
		hbox.pack_start(self.sendbutton, False, False, 0)
		frame.add(hbox)
		frame.show()
		vbox.pack_start(frame, False, False, 0)
		self.sendbutton.show()
		hbox.show()

		frame = gtk.Frame('Text:')
		sw = gtk.ScrolledWindow()
		sw.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_ALWAYS)
		self.textview = gtk.TextView()
		self.textbuffer = self.textview.get_buffer()
		s = "Enter a phonenumber and click 'Check Number'.\n"
		s += "If the number is accepted, you can enter the text here."
		self.textbuffer.set_text(s)
		self.textview.set_editable(False)
		self.textview.set_wrap_mode(gtk.WRAP_WORD)
		sw.add(self.textview)
		frame.add(sw)
		self.textview.show()
		frame.show()
		sw.show()
		self.textbuffer.connect("changed", self.update_text_char)

		vbox.pack_start(frame, True, True, 5)

		self.charcount = gtk.Label()
		vbox.pack_start(self.charcount, False, True, 3)
		self.charcount.show()

		table = gtk.Table(rows=2, columns=2)
		label = gtk.Label('Status:')
		table.attach(label, 0, 1, 0, 1)
		label.show()

		self.l_status = gtk.Label()
		table.attach(self.l_status, 1, 2, 0, 1)
		self.l_status.show()

		label = gtk.Label('Price:')
		table.attach(label, 0, 1, 1, 2)
		label.show()

		self.l_price = gtk.Label()
		table.attach(self.l_price, 1, 2, 1, 2)
		self.l_price.show()

		label = gtk.Label('Target(s):')
		table.attach(label, 0, 1, 2, 3)
		label.show()

		self.l_target = gtk.Label()
		table.attach(self.l_target, 1, 2, 2, 3)
		self.l_target.show()

		label = gtk.Label('ReplyToNumber:')
		table.attach(label, 0, 1, 3, 4)
		label.show()

		self.l_replyto = gtk.Label()
		table.attach(self.l_replyto, 1, 2, 3, 4)
		self.l_replyto.show()

		vbox.pack_start(table, True, True, 0)
		table.show()

		# Set Number from CmdLine if anything given.
		if len(sys.argv) == 2:
			self.entry.set_active_iter(self.entry_ls.append([sys.argv[1], sys.argv[1]]))

		# Now show everything
		vbox.show()
		return vbox


