/*  smplayer, GUI front-end for mplayer.
    Copyright (C) 2007 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* This file is based on the "small client-server example" from Qt */
/* Copyright (C) 1992-2000 Trolltech AS. */


#include "client.h"
#include <qsocket.h>
#include <qtextstream.h>
#include <qtimer.h>

MyClient::MyClient( Q_UINT16 port, QObject * parent, const char * name ) 
	: QObject(parent,name)
{
	// create the socket and connect various of its signals
	socket = new QSocket( this );
	connect( socket, SIGNAL(connected()),
	         SLOT(socketConnected()) );
	connect( socket, SIGNAL(connectionClosed()),
	         SLOT(socketConnectionClosed()) );
	connect( socket, SIGNAL(readyRead()),
	         SLOT(socketReadyRead()) );
	connect( socket, SIGNAL(error(int)),
	         SLOT(socketError(int)) );

	timer = new QTimer(this);
	connect( timer, SIGNAL(timeout()), this, SIGNAL( serverDontRespond()) );

	identified_server = FALSE;
	sent_unknown_server_signal = FALSE;

	// connect to the server
	qDebug("MyClient::MyClient: trying to connect to the server");
	socket->connectToHost( "localhost", port );
}

MyClient::~MyClient() {
}

void MyClient::closeConnection() {
	socket->close();
	if ( socket->state() == QSocket::Closing ) {
		// We have a delayed close.
		connect( socket, SIGNAL(delayedCloseFinished()),
	             SLOT(socketClosed()) );
	} else {
		// The socket is closed.
		socketClosed();
	}
}

void MyClient::sendToServer(QString text) {
	qDebug("MyClient::sendToServer: '%s'", text.utf8().data());
	// write to the server
	QTextStream os(socket);
	os.setEncoding( QTextStream::UnicodeUTF8 );
	os << text << "\n";
	socket->flush();
}

void MyClient::socketReadyRead() {
	// read from the server
	while ( socket->canReadLine() ) {
		timer->stop(); // Server has responded

		// In Qt 4 readline doesn't return a QString
		QString s( socket->readLine() ); 
		qDebug("MyClient::socketReadyRead: '%s'", s.utf8().data() );

		if ( (s.startsWith("SMPlayer")) || 
             (s.startsWith("I'm smplayer too, go on")) )
		{
			qDebug("MyClient::socketReadyRead: Identified server!");
			if (!identified_server) {
				identified_server = TRUE;
				emit serverIdentified();
			}
		} 
		else {
			if ((!identified_server) && (!sent_unknown_server_signal)) {
				sent_unknown_server_signal = TRUE;
				emit unknownServer();
			}
		}
	}
}

void MyClient::socketConnected() {
	qDebug("MyClient::socketConnected: connected to server");
	emit connected();

	sendToServer("Hello");
	//sendToServer("Hello, this is smplayer");
	//sendToServer("hi");

	timer->start(4000, TRUE);
}

void MyClient::socketConnectionClosed() {
	qDebug("MyClient::socketConnectionClosed: connection closed by the server");
}

void MyClient::socketClosed() {
	qDebug("MyClient::socketClosed: connection closed");
	emit connectionClosed();
}

void MyClient::socketError( int e ) {
	qDebug("MyClient::socketError: error number %d occurred", e);
	if ( (e == QSocket::ErrHostNotFound) ||
         (e == QSocket::ErrConnectionRefused) ) 
	{
		emit notConnected();
	}
}
