/*  smplayer, GUI front-end for mplayer.
    Copyright (C) 2007 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _CORE_H_
#define _CORE_H_

#include <qobject.h>

#include "mediadata.h"
#include "mediasettings.h"


class MplayerProcess;
class MplayerWindow;

class Core : public QObject
{
    Q_OBJECT
    
public:
    Core( MplayerWindow *mpw, QWidget* parent = 0, const char* name = 0 );
    ~Core();

    MediaData mdat;
	MediaSettings mset;

    QString mplayer_log;

    #define PLAYING 0
    #define PAUSED 1
    #define STOPPED 2

    int state;
    
public slots:
	virtual void open(QString file, int seek=-1); // Generic open, autodetect type
	virtual void openFile(QString filename, int seek=-1);
	virtual void openStream(QString name);
	/*
	virtual void openDVD( bool from_folder, QString directory = "");
	virtual void openDVD(); // Plays title 1
	virtual void openDVD(int title = 1);
	*/
	virtual void openDVD(QString dvd_url);
	virtual void openVCD(int title = -1);
	virtual void openAudioCD(int title = -1);

	virtual void loadSub(const QString & sub);
	virtual void unloadSub();

	virtual void loadAudioFile(const QString & audiofile);
	virtual void unloadAudioFile();

    virtual void stop(); 
    virtual void play();
	virtual void play_or_pause();
    virtual void pause_and_frame_step();
	virtual void pause();
	virtual void frameStep();
	virtual void screenshot();

	// Public restart, for the GUI.
	virtual void restart();

    virtual void goToPos( int perc );
    /*virtual void goToSec( double sec );*/

	virtual void toggleRepeat();
	virtual void toggleRepeat(bool b);

	// Audio filters
	virtual void toggleKaraoke();
	virtual void toggleKaraoke(bool b);
	virtual void toggleExtrastereo();
	virtual void toggleExtrastereo(bool b);
	virtual void toggleVolnorm();
	virtual void toggleVolnorm(bool b);

	virtual void setAudioChannels(int channels);
	virtual void setStereoMode(int mode);

	// Video filters
	virtual void toggleAutophase();
	virtual void toggleAutophase(bool b);
	virtual void toggleDeblock();
	virtual void toggleDeblock(bool b);
	virtual void toggleDering();
	virtual void toggleDering(bool b);
	virtual void toggleNoise();
	virtual void toggleNoise(bool b);
	virtual void togglePostprocessing();
	virtual void togglePostprocessing(bool b);
	virtual void changeDenoise(int);

	virtual void seek(int secs);
	virtual void sforward(); 	// + 10 seconds
	virtual void srewind(); 	// - 10 seconds
    virtual void forward(); 	// + 1 minute
    virtual void rewind(); 		// -1 minute
    virtual void fastforward();	// + 10 minutes
    virtual void fastrewind();	// - 10 minutes
	virtual void forward(int secs);
	virtual void rewind(int secs);
	virtual void wheelUp();
	virtual void wheelDown();

	virtual void setSpeed( double value );
	virtual void incSpeed();
	virtual void decSpeed();
	virtual void doubleSpeed();
	virtual void halveSpeed();
	virtual void normalSpeed();

    virtual void setVolume(int volume, bool force=FALSE);
	virtual void switchMute();
	virtual void mute(bool b);
	virtual void incVolume();
	virtual void decVolume();

	virtual void setBrightness(int value);
	virtual void setContrast(int value);
	virtual void setGamma(int value);
	virtual void setHue(int value);
	virtual void setSaturation(int value);

	virtual void incBrightness();
	virtual void decBrightness();
	virtual void incContrast();
	virtual void decContrast();
	virtual void incGamma();
	virtual void decGamma();
	virtual void incHue();
	virtual void decHue();
	virtual void incSaturation();
	virtual void decSaturation();

	virtual void incSubDelay();
	virtual void decSubDelay();

	virtual void incAudioDelay();
	virtual void decAudioDelay();

	virtual void incSubPos();
	virtual void decSubPos();

	// Select next line in subtitle file
	virtual void incSubStep();
	// Select previous line in subtitle file
	virtual void decSubStep();

	virtual void changeDeinterlace(int);
    virtual void changeSubtitle(int);
	virtual void nextSubtitle();
	virtual void changeAudio(int);
	virtual void nextAudio();
	virtual void changeTitle(int);
	virtual void changeChapter(int);
	virtual void prevChapter();
	virtual void nextChapter();
	virtual void changeAngle(int);
	virtual void changeAspectRatio(int);
	virtual void changeOSD(int);
	virtual void nextOSD();

	virtual void changeSize(int); // Size of the window
	virtual void toggleDoubleSize();
	virtual void changePanscan(double); // Zoom on mplayerwindow

	virtual void incPanscan();
	virtual void decPanscan();
	virtual void resetPanscan();

    // Pass a command to mplayer by stdin:
    virtual void tellmp(const QString & command);

	// Change the clearing of the mplayerwindow background,
	// according to pref->always_clear_background
	virtual void prepareMplayerWindow();


protected slots:
    virtual void changeCurrentSec(double sec);
    virtual void changePause();
	virtual void gotWindowResolution( int w, int h );
	virtual void gotNoVideo();
	virtual void gotVO(QString);
	virtual void gotAO(QString);
	virtual void gotStartingTime(double);

	virtual void finishRestart();
    virtual void processFinished();
	virtual void fileReachedEnd();
    
	virtual void updateLog(QString line);

	virtual void displayMessage(QString text);
	virtual void displayScreenshotName(QString filename);

	virtual void streamTitleAndUrlChanged(QString,QString);

	// Called when the state has changed (playing, stopped...)
	// to allow or disallow clearing the background.
	virtual void prepareMplayerWindow(int);
    
protected:
	virtual void playNewFile(QString file, int seek=-1);
	virtual void restartPlay();
	virtual void initPlaying(int seek=-1);
	virtual void newMediaPlaying();

    virtual void startMplayer(QString file, double seek = -1 );
	virtual void stopMplayer();

	virtual bool checkHaveSettingsSaved(QString filename);
	virtual void saveMediaInfo();
	virtual void loadMediaInfo(QString filename);

    virtual void initializeMenus();
	virtual void updateWidgets();

signals:
	void mediaLoaded();
	void mediaInfoChanged();
    void stateChanged(int state);
	void mediaStartPlay();
	void mediaFinished(); // Media has arrived to the end.
	void mediaStoppedByUser();
	void showMessage(QString text);
	void menusNeedInitialize();
	void widgetsNeedUpdate();
	void equalizerNeedsUpdate();
	void showTime(double sec);
	void showFrame(int frame);
	void needResize(int w, int h);
	void mplayerFinishedWithError(int);
	void noVideo();
	void volumeChanged(int);

protected:
    MplayerProcess * proc;
    MplayerWindow *mplayerwindow;
    
private:
	// Some variables to proper restart
	bool we_are_restarting;

	bool just_loaded_external_subs;
	bool just_unloaded_external_subs;
};
    
#endif
