/*  smplayer, GUI front-end for mplayer.
    Copyright (C) 2007 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _FILEDIALOG_H
#define _FILEDIALOG_H

#include <qstring.h>
#include <qstringlist.h>

class QWidget;

class MyFileDialog {

public:
	static QString getOpenFileName ( const QString & startWith = QString::null, 
                            const QString & filter = QString::null, 
                            QWidget * parent = 0, const char * name = 0, 
                            const QString & caption = QString::null, 
                            QString * selectedFilter = 0, 
                            bool resolveSymlinks = TRUE );

	static QString getExistingDirectory ( const QString & dir = QString::null, 
                               QWidget * parent = 0, const char * name = 0, 
                               const QString & caption = QString::null, 
                               bool dirOnly = TRUE, 
                               bool resolveSymlinks = TRUE );

	static QString getSaveFileName ( const QString & startWith = QString::null, 
                            const QString & filter = QString::null, 
                            QWidget * parent = 0, const char * name = 0, 
                            const QString & caption = QString::null, 
                            QString * selectedFilter = 0, 
                            bool resolveSymlinks = TRUE );

	static QStringList getOpenFileNames ( const QString & filter = QString::null, 
                               const QString & dir = QString::null, 
                               QWidget * parent = 0, const char * name = 0, 
                               const QString & caption = QString::null, 
                               QString * selectedFilter = 0, 
                               bool resolveSymlinks = TRUE );

#if KDE_SUPPORT
protected:
	static QString convertFilter( QString qt_filter );
#endif

};

#endif

