/*  smplayer, GUI front-end for mplayer.
    Copyright (C) 2007 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* 
    Note: most of the code in this class has been taken from the source 
    code of Qt-3 Designer (propertyeditor.h and propertyeditor.cpp).
	Copyright (C) 2000 Trolltech AS.
*/


#include "keychooser.h"
#include <qkeysequence.h>


KeyChooser::KeyChooser( QWidget * parent, const char * name ) 
	: QLineEdit(parent, name)
{
	num=0;
	k1=0; k2=0; k3=0; k4=0;
	mouseEnter = false;
}

KeyChooser::~KeyChooser() {
}

void KeyChooser::clear() {
	num=0;
	k1=0; k2=0; k3=0; k4=0;
	QLineEdit::clear();
}

void KeyChooser::keyPressEvent( QKeyEvent * e ) {
	num = 0;
	int nextKey = e->key();

    if ( num > 3 ||
         nextKey == Qt::Key_Control ||
         nextKey == Qt::Key_Shift ||
         nextKey == Qt::Key_Meta ||
         nextKey == Qt::Key_Alt )
	{
		e->ignore();
         return;
	}

    nextKey |= translateModifiers( e->state() );
    switch( num ) {
        case 0:
            k1 = nextKey;
            break;
        case 1:
            k2 = nextKey;
            break;
        case 2:
            k3 = nextKey;
            break;
        case 3:
            k4 = nextKey;
            break;
        default:
            break;
    }
    //num++;
    QKeySequence ks( k1, k2, k3, k4 );
    setText( ks );

	e->accept();
	qDebug("KeyChooser::keyPressEvent: num = %d", num);
}

bool KeyChooser::event( QEvent * e ) {
	if ( e->type() == QEvent::KeyPress ) {
		QKeyEvent *k = (QKeyEvent *)e;
		if ( !mouseEnter &&
            (k->key() == Qt::Key_Up ||
             k->key() == Qt::Key_Down) )
            return QLineEdit::event(e); //FALSE;
		keyPressEvent(k);
        return TRUE;
    } else if ( (e->type() == QEvent::FocusIn) ||
                (e->type() == QEvent::MouseButtonPress) ) {
        mouseEnter = (e->type() == QEvent::MouseButtonPress);
        return TRUE;
    }

    // Lets eat accelerators now..
    if ( e->type() == QEvent::Accel ||
         e->type() == QEvent::AccelOverride  ||
         e->type() == QEvent::KeyRelease )
        return TRUE;

	//return FALSE;
	return QLineEdit::event(e);
}

int KeyChooser::translateModifiers( int state ) {
    int result = 0;
    if ( state & Qt::ShiftButton )
        result |= Qt::SHIFT;
    if ( state & Qt::ControlButton )
        result |= Qt::CTRL;
    if ( state & Qt::MetaButton )
        result |= Qt::META;
    if ( state & Qt::AltButton )
        result |= Qt::ALT;
    return result;
}
