/*  smplayer, GUI front-end for mplayer.
    Copyright (C) 2007 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _MPLAYERPROCESS_H_
#define _MPLAYERPROCESS_H_

#include <qprocess.h>
#include <qstring.h>
//#include <qcstring.h>
#include "mediadata.h"


#ifdef Q_OS_WIN
#define DONT_USE_SIGNALS 1
#else
#define DONT_USE_SIGNALS 0
#endif


#if DONT_USE_SIGNALS
class QTimer;
#endif

class QStringList;

class MplayerProcess : public QProcess 
{
	Q_OBJECT

public:
	MplayerProcess(QObject * parent = 0, const char * name = 0 );
	~MplayerProcess();

	virtual bool start( QStringList * env = 0 );

	MediaData mediaData() { return md; };

signals:
	void lineAvailable(QString line);

	void receivedCurrentSec(double sec);
	void receivedCurrentFrame(int frame);
	void receivedPause();
	void receivedWindowResolution(int,int);
	void receivedNoVideo();
	void receivedVO(QString);
	void receivedAO(QString);
	void receivedEndOfFile();
	void mplayerFullyLoaded();
	void receivedStartingTime(double sec);

	void receivedCacheMessage(QString);
	void receivedCreatingIndex(QString);
	void receivedConnectingToMessage(QString);
	void receivedResolvingMessage(QString);
	void receivedScreenshot(QString);

	void receivedStreamTitleAndUrl(QString,QString);


protected slots:
	void read();
	void read(const QByteArray & new_text);
	void readFromStderr();
	void parseLine(QString line);

	void startReading();
	void stopReading();

protected:
	void init_rx();

private:
	QString incomplete_line;
	bool notified_mplayer_is_running;

	MediaData md;

	int last_sub_id;

#if DONT_USE_SIGNALS
	QTimer * timer;
#endif
};


#endif
