/*  smplayer, GUI front-end for mplayer.
    Copyright (C) 2007 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _MYSYSTEMTRAYICON_H_
#define _MYSYSTEMTRAYICON_H_

#if KDE_SUPPORT
#include <ksystemtray.h>
#include <qpixmap.h>

#include "baseguiplus.h"

class MySystemTrayIcon : public KSystemTray {
	Q_OBJECT

public:
	enum MessageIcon { NoIcon, Information, Warning, Critical };

	MySystemTrayIcon( QPixmap icon, QWidget *parent=0, const char *name=0 );
	~MySystemTrayIcon();

	void setContextMenu(QPopupMenu * menu) { context_menu = menu; };
	QPopupMenu * contextMenu() { return context_menu; };
	void setToolTip( const QString & tip );
	QString toolTip() { return tool_tip; };

	void showMessage( const QString & title, const QString & message, 
                      MessageIcon icon = Information, int milliseconds = 10000)
	{};

public slots:
	void setVisible( bool visible );

signals:
	void activated ( QSystemTrayIcon::ActivationReason reason );

protected:
	void mousePressEvent(QMouseEvent *e );

	QPopupMenu * context_menu;
	QString tool_tip;
};

#endif

#endif
