/*  smplayer, GUI front-end for mplayer.
    Copyright (C) 2007 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "images.h"
#include <qpixmap.h>
#include <qimage.h>

#include "icons/rewind10m.xpm"
#include "icons/rewind1m.xpm"
#include "icons/rewind10s.xpm"

#include "icons/forward10m.xpm"
#include "icons/forward1m.xpm"
#include "icons/forward10s.xpm"

#include "icons/play.xpm"
#include "icons/pause.xpm"
#include "icons/stop.xpm"

#include "icons/fullscreen.xpm" // From Vista-Inspirate

#include "icons/open.xpm" 	// From Crystal Clear
#include "icons/openfolder.xpm"	// From Crystal Clear
#include "icons/dvd.xpm" 	// From Crystal Clear
#include "icons/dvd_hd.xpm" // From Vista-Inspirate
#include "icons/url.xpm" 	// From Crystal Clear
#include "icons/title.xpm"  	// From gmplayer
#include "icons/chapter.xpm"	// From gmplayer
#include "icons/aspect.xpm"		// From gmplayer
#include "icons/sub.xpm"		// From gmplayer
#include "icons/prefs.xpm"	// From Crystal Clear

#include "icons/volume.xpm"		// From kplayer
#include "icons/mute.xpm"		// From kplayer

#include "icons/info.xpm"	// From Crystal Clear
#include "icons/save.xpm"	// From Crystal Clear
#include "icons/copy.xpm"	// From Crystal Clear

#include "icons/screenshot.xpm"	// Vista-Inspirate
#include "icons/logs.xpm"	// From Crystal Clear

#include "icons/media-player.xpm" 		// From Vista-Inspirate
#include "icons/media-player_64.xpm"	// From Vista-Inspirate

// Preferences
#include "icons/pref_general.xpm"	// From Vista-Inspirate
#include "icons/pref_subtitles.xpm"	// From Vista-Inspirate
#include "icons/pref_devices.xpm"	// From Vista-Inspirate
#include "icons/pref_advanced.xpm"	// From Vista-Inspirate
#include "icons/pref_performance.xpm"	// From Vista-Inspirate
//#include "icons/pref_misc.xpm"			// From Vista-Inspirate
#include "icons/pref_gui.xpm"		// From Vista-Inspirate
#include "icons/dvd_drive.xpm"		// From ricebowl-0.2.0 (http://www.deviantart.com/deviation/22605468/)
#include "icons/cdrom_drive.xpm"	// From ricebowl-0.2.0 (http://www.deviantart.com/deviation/22605468/)
#include "icons/mouse.xpm"			// From Crystal Clear
#include "icons/resize_window.xpm"	// From Crystal Clear
#include "icons/monitor.xpm"		// From Crystal Clear
#include "icons/speaker.xpm"		// From Crystal Clear

// Playlist
#include "icons/plus.xpm"			// From Crystal Clear
#include "icons/minus.xpm"			// From Crystal Clear
#include "icons/previous.xpm"
#include "icons/next.xpm"
#include "icons/repeat.xpm"
#include "icons/shuffle.xpm"
#include "icons/up.xpm"				// From Crystal Clear
#include "icons/down.xpm"			// From Crystal Clear
#include "icons/playlist.xpm"		// From Crystal Clear
#include "icons/ok.xpm"				// From Vista-Inspirate

// Video equalizer
#include "icons/saturation.xpm"		// From rulesPlayer
#include "icons/brightness.xpm"		// From rulesPlayer
#include "icons/contrast.xpm"		// From rulesPlayer
#include "icons/hue.xpm"			// From rulesPlayer


Images::Images() {
	m["rewind10s"] = QPixmap( (const char **) rewind10s_xpm );
	m["rewind1m"] = QPixmap( (const char **) rewind1m_xpm );
	m["rewind10m"] = QPixmap( (const char **) rewind10m_xpm );

	m["forward10s"] = QPixmap( (const char **) forward10s_xpm );
	m["forward1m"] = QPixmap( (const char **) forward1m_xpm );
	m["forward10m"] = QPixmap( (const char **) forward10m_xpm );

	m["play"] = QPixmap( (const char **) play_xpm );
	m["pause"] = QPixmap( (const char **) pause_xpm );
	m["stop"] = QPixmap( (const char **) stop_xpm );

	m["fullscreen"] = QPixmap( (const char **) fullscreen_xpm );

	m["open"] = QPixmap( (const char **) open_xpm );
	m["open_folder"] = QPixmap( (const char **) openfolder_xpm );
	m["dvd"] = QPixmap( (const char **) dvd_xpm );
	m["dvd_hd"] = QPixmap( (const char **) dvd_hd_xpm );
	m["url"] = QPixmap( (const char **) url_xpm );

	m["title"] = QPixmap( (const char **) title_xpm );
	m["chapter"] = QPixmap( (const char **) chapter_xpm );

	m["aspect"] = QPixmap( (const char **) aspect_xpm );

	m["subs"] = QPixmap( (const char **) sub_xpm );
	m["prefs"] = QPixmap( (const char **) prefs_xpm );

	m["volume"] = QPixmap( (const char **) volume_xpm );
	m["mute"] = QPixmap( (const char **) mute_xpm );

	m["info"] = QPixmap( (const char **) info_xpm );
	m["copy"] = QPixmap( (const char **) copy_xpm );
	m["save"] = QPixmap( (const char **) save_xpm );

	m["screenshot"] = QPixmap( (const char **) screenshot_xpm );
	m["logs"] = QPixmap( (const char **) logs_xpm );

	m["plus"] = QPixmap( (const char **) plus_xpm );
	m["minus"] = QPixmap( (const char **) minus_xpm );
	m["previous"] = QPixmap( (const char **) previous_xpm );
	m["next"] = QPixmap( (const char **) next_xpm );
	m["repeat"] = QPixmap( (const char **) repeat_xpm );
	m["shuffle"] = QPixmap( (const char **) shuffle_xpm );
	m["up"] = QPixmap( (const char **) up_xpm );
	m["down"] = QPixmap( (const char **) down_xpm );

	m["playlist"] = QPixmap( (const char **) playlist_xpm );
	m["ok"] = QPixmap( (const char **) ok_xpm );

	// Video equalizer
	m["contrast"] = QPixmap( (const char **) contrast_xpm );
	m["saturation"] = QPixmap( (const char **) saturation_xpm );
	m["hue"] = QPixmap( (const char **) hue_xpm );
	m["brightness"] = QPixmap( (const char **) brightness_xpm );

	m["logo"] = QPixmap( (const char **) media_player_xpm );
	m["logo_small"] = QPixmap( (const char **) media_player_64_xpm );

	// Preferences dialog
	m["pref_general"] = QPixmap( (const char **) pref_general_xpm );
	m["pref_subtitles"] = QPixmap( (const char **) pref_subtitles_xpm );
	m["pref_devices"] = QPixmap( (const char **) pref_devices_xpm );
	m["pref_advanced"] = QPixmap( (const char **) pref_advanced_xpm );
	//m["pref_misc"] = QPixmap( (const char **) pref_misc_xpm );
	m["pref_gui"] = QPixmap( (const char **) pref_gui_xpm );
	m["pref_performance"] = QPixmap( (const char **) pref_performance_xpm );

	m["dvd_drive"] = QPixmap( (const char **) dvd_drive_xpm );
	m["cdrom_drive"] = QPixmap( (const char **) cdrom_drive_xpm );
	m["mouse"] = QPixmap( (const char **) mouse_xpm );
	m["resize_window"] = QPixmap( (const char **) resize_window_xpm );
	m["monitor"] = QPixmap( (const char **) monitor_xpm );
	m["speaker"] = QPixmap( (const char **) speaker_xpm );

#define SIZE 20
	m["rewind10s_small"] = resize( &m["rewind10s"], SIZE );
	m["rewind1m_small"] = resize( &m["rewind1m"], SIZE );
	m["rewind10m_small"] = resize( &m["rewind10m"], SIZE );

	m["forward10s_small"] = resize( &m["forward10s"], SIZE );
	m["forward1m_small"] = resize( &m["forward1m"], SIZE );
	m["forward10m_small"] = resize( &m["forward10m"], SIZE );

	m["play_small"] = resize( &m["play"], SIZE );
	m["pause_small"] = resize( &m["pause"], SIZE );
	m["stop_small"] = resize( &m["stop"], SIZE );

	m["fullscreen_small"] = resize( &m["fullscreen"], SIZE );
	m["volume_small"] = resize( &m["volume"], SIZE );
	m["mute_small"] = resize( &m["mute"], SIZE );

	m["minus_small"] = resize( &m["minus"], SIZE );
	m["plus_small"] = resize( &m["plus"], SIZE );
	m["previous_small"] = resize( &m["previous"], SIZE );
	m["next_small"] = resize( &m["next"], SIZE );
	m["repeat_small"] = resize( &m["repeat"], SIZE );
	m["shuffle_small"] = resize( &m["shuffle"], SIZE );
	m["up_small"] = resize( &m["up"], SIZE );
	m["down_small"] = resize( &m["down"], SIZE );

	m["playlist_small"] = resize( &m["playlist"], SIZE );
	m["ok_small"] = resize( &m["ok"], 16 );

	m["mouse_small"] = resize( &m["mouse"], SIZE );
}

Images::~Images() {
}

QPixmap Images::icon(QString name) {
	if (m.contains(name)) 
		return m[name];
	else
		return QPixmap();
}

QPixmap Images::resize(QPixmap *p, int size) {
	QPixmap pix;
	pix.convertFromImage( (*p).convertToImage().smoothScale(size,size) );
	return pix;
}
