/*  smplayer, GUI front-end for mplayer.
    Copyright (C) 2007 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _KEYS_H_
#define _KEYS_H_

#include <qstring.h>
#include <qstringlist.h>
#include <qvaluelist.h>
#include <qkeysequence.h>

class QKeyEvent;

class KeyAccel {

public:

	KeyAccel();
	KeyAccel( QString function, QKeySequence seq );
	~KeyAccel();

	QKeySequence keySequence() { return _seq; };
	QString function() { return _function; };
	bool check( QKeyEvent *e );

	static QKeySequence convertKey( QKeyEvent *e );

private:
	QKeySequence _seq;
	QString _function;
};


class KeyShortcuts {

public:
	KeyShortcuts();
	~KeyShortcuts();

	QString function(QKeyEvent *e);
	QKeySequence find( QString function );

	QStringList functionList();

	void list();
	void save();
	void load();

private:
	typedef QValueList<KeyAccel> KeyAccelList;
	KeyAccelList kl;
};

#endif

