/*  smplayer, GUI front-end for mplayer.
    Copyright (C) 2007 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "guibase.h"
#include "timeslider.h"

#include <qpushbutton.h>
#include <qframe.h>
#include <qslider.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qaction.h>
#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qtoolbar.h>
#include <qpixmap.h>
#include <qtooltip.h>

#include "keys.h"
#include "images.h"
#include "global.h"


GuiBase::GuiBase( QWidget* parent, const char* name, WFlags fl )
    : QMainWindow( parent, name, fl )
{
	setCaption( "SMPlayer" );

	centralwidget = new QWidget(this, "central widget");
	setCentralWidget( centralwidget );

	centralwidgetLayout = new QVBoxLayout( centralwidget, 0, 0, "centralwidgetLayout");

	//panel = new QFrame( centralwidget, "panel" );
	panel = new QWidget( centralwidget, "panel" );
    panel->setSizePolicy( QSizePolicy::Expanding, QSizePolicy::Expanding );
    //panel->setFocusPolicy( NOFOCUS );
	/*
    panel->setFrameShape( QFrame::NoFrame );
    panel->setFrameShadow( QFrame::Plain );
    panel->setLineWidth( 0 );
    panel->setMargin( 0 );
	*/
	panel->setMinimumSize( QSize(0,0) );

    centralwidgetLayout->addWidget( panel );

	controlwidget = new QWidget( centralwidget, "control widget");
	controlwidgetLayout = new QVBoxLayout( controlwidget, 2, 0, "controlwidgetLayout");

	// Up part
	fastrewindbutton = new QPushButton( controlwidget, "fastrewindbutton" );
	fastrewindbutton->setFocusPolicy( NOFOCUS );

	rewindbutton = new QPushButton( controlwidget, "rewindbutton" );
	rewindbutton->setFocusPolicy( NOFOCUS );

	smallrewindbutton = new QPushButton( controlwidget, "smallrewindbutton" );
	smallrewindbutton->setFocusPolicy( NOFOCUS );

	timeslider = new TimeSlider( controlwidget, "timeslider" );
    timeslider->setFocusPolicy( NOFOCUS );
    timeslider->setOrientation( Qt::Horizontal );

	smallforwardbutton = new QPushButton( controlwidget, "smallforwardbutton" );
	smallforwardbutton->setFocusPolicy( NOFOCUS );

	forwardbutton = new QPushButton( controlwidget, "forwardbutton" );
	forwardbutton->setFocusPolicy( NOFOCUS );

	fastforwardbutton = new QPushButton( controlwidget, "fastforwardbutton" );
	fastforwardbutton->setFocusPolicy( NOFOCUS );

	layout1 = new QHBoxLayout( 0, 0, 0, "layout1");
	layout1->addWidget( fastrewindbutton );
	layout1->addWidget( rewindbutton );
	layout1->addWidget( smallrewindbutton );
	layout1->addWidget( timeslider );
	layout1->addWidget( smallforwardbutton );
	layout1->addWidget( forwardbutton );
	layout1->addWidget( fastforwardbutton );

	controlwidgetLayout->addLayout( layout1 );

	// Down part
	playbutton = new QPushButton( controlwidget, "playbutton" );
	playbutton->setFocusPolicy( NOFOCUS );

	pausebutton = new QPushButton( controlwidget, "pausebutton" );
	pausebutton->setFocusPolicy( NOFOCUS );

	stopbutton = new QPushButton( controlwidget, "stopbutton" );
	stopbutton->setFocusPolicy( NOFOCUS );

	spacer1 = new QSpacerItem( 270, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );

	playlistbutton = new QPushButton( controlwidget, "playlistbutton" );
	playlistbutton->setToggleButton( TRUE );

	playlistbutton->setFocusPolicy( NOFOCUS );

	spacer2 = new QSpacerItem( 30, 20, QSizePolicy::Preferred, QSizePolicy::Minimum );

	prevbutton = new QPushButton( controlwidget, "prevbutton" );
	prevbutton->setFocusPolicy( NOFOCUS );
	prevbutton->setAccel( key_list->find("PLAYLIST_PREV") );

	nextbutton = new QPushButton( controlwidget, "nextbutton" );
	nextbutton->setFocusPolicy( NOFOCUS );
	nextbutton->setAccel( key_list->find("PLAYLIST_NEXT") );

	spacer3 = new QSpacerItem( 50, 20, QSizePolicy::Preferred, QSizePolicy::Minimum );

	fullscreenbutton = new QPushButton( controlwidget, "fullscreenbutton" );

	fullscreenbutton->setToggleButton( TRUE );

	fullscreenbutton->setFocusPolicy( NOFOCUS );

	mutebutton = new QPushButton( controlwidget, "mutebutton" );

	mutebutton->setToggleButton( TRUE );

	mutebutton->setFocusPolicy( NOFOCUS );

	volumeslider = new MySlider( controlwidget, "volumeslider" );

	volumeslider->setOrientation( Qt::Horizontal );
    volumeslider->setSizePolicy( QSizePolicy::Fixed, QSizePolicy::Fixed );
	volumeslider->setFocusPolicy( NOFOCUS );
	volumeslider->setTickmarks( QSlider::Below );
	volumeslider->setTickInterval( 10 );
	volumeslider->setLineStep( 1 );
	volumeslider->setPageStep( 10 );


	layout2 = new QHBoxLayout( 0, 0, 0, "layout2");
	layout2->addWidget( playbutton );
	layout2->addWidget( pausebutton );
	layout2->addWidget( stopbutton );
	layout2->addItem( spacer1 );
	layout2->addWidget( playlistbutton );
	layout2->addItem( spacer2 );
	layout2->addWidget( prevbutton );
	layout2->addWidget( nextbutton );
	layout2->addItem( spacer3 );
	layout2->addWidget( fullscreenbutton );
	layout2->addWidget( mutebutton );
	layout2->addWidget( volumeslider );

	controlwidgetLayout->addLayout( layout2 );

	centralwidgetLayout->addWidget( controlwidget );

	controlwidget->setSizePolicy( QSizePolicy::Preferred , QSizePolicy::Fixed ); 

	#if QT_VERSION < 0x040000
	layout()->setSpacing(-1); // Removes two extra lines
	#endif

	languageChange();

	resize(580, 440);

	panel->setFocus();
}


GuiBase::~GuiBase()
{
    // no need to delete child widgets, Qt does it all for us
}

void GuiBase::languageChange() {
	// Main window icon
	setIcon( Images::icon("logo", 64) );

	// Widgets
	QToolTip::add( fastrewindbutton, tr("-10 minutes") );
	fastrewindbutton->setPixmap( Images::icon("rewind10m_small") );

	QToolTip::add( rewindbutton, tr("-1 minute") );
	rewindbutton->setPixmap( Images::icon("rewind1m_small") );

	QToolTip::add( smallrewindbutton, tr("-10 seconds") );
	smallrewindbutton->setPixmap( Images::icon("rewind10s_small") );

	QToolTip::add( smallforwardbutton, tr("+10 seconds") );
	smallforwardbutton->setPixmap( Images::icon("forward10s_small") );

	QToolTip::add( forwardbutton, tr("+1 minute") );
	forwardbutton->setPixmap( Images::icon("forward1m_small") );

	QToolTip::add( fastforwardbutton, tr("+10 minutes") );
	fastforwardbutton->setPixmap( Images::icon("forward10m_small") );

	QToolTip::add( playbutton, tr("Play") );
	playbutton->setPixmap( Images::icon("play_small") );

	QToolTip::add( pausebutton, tr("Pause") );
	pausebutton->setPixmap( Images::icon("pause_small") );

	QToolTip::add( stopbutton, tr("Stop") );
	stopbutton->setPixmap( Images::icon("stop_small") );

	QToolTip::add( playlistbutton, tr("Playlist") );
	playlistbutton->setPixmap( Images::icon("playlist_small") );

	QToolTip::add( prevbutton, tr("Previous") );
	prevbutton->setPixmap( Images::icon("previous_small") );

	QToolTip::add( nextbutton, tr("Next") );
	nextbutton->setPixmap( Images::icon("next_small") );

	QToolTip::add( fullscreenbutton, tr("Fullscreen") );
	fullscreenbutton->setPixmap( Images::icon("fullscreen_small") );

	QToolTip::add( mutebutton, tr("Mute") );
	mutebutton->setPixmap( Images::icon("volume_small") );

	QToolTip::add( volumeslider, tr("Volume") );
}

