/*  smplayer, GUI front-end for mplayer.
    Copyright (C) 2007 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef _GUIBASE_H_
#define _GUIBASE_H_

#include <qmainwindow.h>

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QSpacerItem;
class QAction;
class QActionGroup;
class QToolBar;
class QPopupMenu;
//class QFrame;
class QWidget;
class QPushButton;
class MySlider;
class TimeSlider;

class GuiBase : public QMainWindow
{
    Q_OBJECT

public:
    GuiBase( QWidget* parent = 0, const char* name = 0, WFlags fl = WType_TopLevel );
    ~GuiBase();

protected slots:
	virtual void languageChange();

protected:
    //QFrame* panel;
	QWidget * panel;
    QPushButton* fastrewindbutton;
    QPushButton* rewindbutton;
    QPushButton* smallrewindbutton;
    TimeSlider* timeslider;
    QPushButton* smallforwardbutton;
    QPushButton* forwardbutton;
    QPushButton* fastforwardbutton;
    QPushButton* playbutton;
    QPushButton* pausebutton;
    QPushButton* stopbutton;
	QPushButton *playlistbutton;
	QPushButton *prevbutton;
	QPushButton *nextbutton;
    QPushButton* fullscreenbutton;
	QPushButton* mutebutton;
    MySlider* volumeslider;

	QSpacerItem* spacer1;
	QSpacerItem* spacer2;
	QSpacerItem* spacer3;

	QWidget * centralwidget;
	QVBoxLayout* centralwidgetLayout;

	QWidget * controlwidget;
	QVBoxLayout * controlwidgetLayout;
	QHBoxLayout* layout1;
    QHBoxLayout* layout2;
};


#endif

