/*  smplayer, GUI front-end for mplayer.
    Copyright (C) 2007 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "trackdata.h"
#include "helper.h"
#include <qfileinfo.h>

TrackData::TrackData() {
	_lang = "";
	_name = "";
	_filename = "";
	_duration = 0;
	_ID = -1;
	_chapters = 0;
	_angles = 0;
}

TrackData::~TrackData() {
}

QString TrackData::displayName() const {
	//qDebug("TrackData::displayName");

	QString dname="";

    if (!_name.isEmpty()) {
        dname = _name;
	}
    else
    if (!_lang.isEmpty()) {
        dname = _lang;
	}
    else
	if (!_filename.isEmpty()) {
		QFileInfo f(_filename);
	    dname = f.fileName();
	}
	else
    dname = QString::number(_ID);

	if (_duration > 0) {
		dname += " ("+ Helper::formatTime( (int) _duration ) +")";
	}

	return dname;
}


void TrackData::save(QSettings & set) {
	//qDebug("TrackData::save");

	set.writeEntry( "lang", _lang );
	set.writeEntry( "name", _name );
	set.writeEntry( "filename", _filename );
	set.writeEntry( "duration", _duration );
	set.writeEntry( "chapters", _chapters );
	set.writeEntry( "angles", _angles );
	set.writeEntry( "ID", _ID );
}

void TrackData::load(QSettings & set) {
	//qDebug("TrackData::load");

	_lang = set.readEntry( "lang", _lang );
	_name = set.readEntry( "name", _name );
	_filename = set.readEntry( "filename", _filename );
	_duration = set.readDoubleEntry( "duration", _duration);
	_chapters = set.readNumEntry( "chapters", _chapters );
	_angles =  set.readNumEntry( "angles", _angles );
	_ID = set.readNumEntry( "ID", _ID );
}

void TrackData::list() {
	//qDebug("TrackData::list");

	qDebug("     ID: '%d' lang: '%s' name: '%s'", _ID, _lang.utf8().data(), _name.utf8().data() );
	qDebug("     filename: '%s' duration: %f chapters: %d angles: %d", 
            _filename.utf8().data(), _duration, _chapters, _angles );
}
