
#ifndef _CONFIG_DIALOGUE_H_
#define _CONFIG_DIALOGUE_H_

#include "config.h"

#include <kdialogbase.h>
#include <knotifydialog.h>
#include <kio/jobclasses.h>

class QSpinBox;
class QComboBox;
class QLabel;
class QStringList;
class QPushButton;
class KPushButton;
class QLineEdit;
class QCheckBox;
class QSlider;
class QListBox;
class QFont;
class KProcess;
class QProgressBar;

class ConfigDialogueInterface;
class ConfigDialogueBackendPlugins;
class ConfigDialogueBackends;
class ConfigDialogueEnDecoder;
class ConfigDialogueEnDecoderOptions;


/**
 * @short Config dialogue
 * @author Daniel Faust <daniel@kaligames.de>
 * @version 0.1
 */
class ConfigDialogue : public KDialogBase
{
    Q_OBJECT
public:
    ConfigDialogue(QWidget *parent = 0, const char *name = 0, int index = -1);

    virtual ~ConfigDialogue();

private:
    QFrame *interfacePage, *backendPluginsPage, *backendsPage, *enDecoderPage, *enDecoderOptionsPage;
    QFrame *addPage(const QString &itemName, const QString &iconName);

    ConfigDialogueInterface *dInterface;
    ConfigDialogueBackendPlugins *dBackendPlugins;
    ConfigDialogueBackends *dBackends;
    ConfigDialogueEnDecoder *dEnDecoder;
    ConfigDialogueEnDecoderOptions *dEnDecoderOptions;

    void setConfigChanged(const bool);

private slots:
    void configChanged();
    void okClickedSlot();
    void applyClickedSlot();
    void defaultClickedSlot();

signals:
    void resetInterface();
    void resetBackendPlugins();
    void resetBackends();
    void resetEnDecoder();
    void resetEnDecoderOptions();

    void saveInterface();
    void saveBackendPlugins();
    void saveBackends();
    void saveEnDecoder();
    void saveEnDecoderOptions();

    void recalcEnDecoderPage();

};

#endif // _CONFIG_DIALOGUE_H_
