

#ifndef _FILELIST_H_
#define _FILELIST_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qwidget.h>

class KListView;
class QListViewItem;
class QStringList;

/**
 * @short File list
 * @author Daniel Faust <daniel@kaligames.de>
 * @version 0.1
 */
class FileList : public QWidget
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    FileList( QWidget *parent=0, const char *name=0 );

    //QStringList firstFile();
    QListViewItem* firstFile();
    int column(QString);

    /**
     * Default Destructor
     */
    virtual ~FileList();

public slots:
    void invert();
    void remove();
    void up();
    void down();
    void top();
    void bottom();
    void addFile(QStringList);
    void removeFirstFile();
    void updateLook();
    void readList();
    void saveList();
    void resetList();

signals:
    void timeRemoved(float);
    void timeAdded(float);
    void addFiles(QStringList);
    void dropped(QDropEvent*);

private:
    KListView *lList;
    QStringList dirFileList;

    void listAllFiles(QString);

protected:
    void dropEvent(QDropEvent*);
    void dragEnterEvent(QDragEnterEvent*);

};

#endif // _FILELIST_H_
