
#ifndef _REPLAYGAIN_PLUGINS_H_
#define _REPLAYGAIN_PLUGINS_H_

#include <qstring.h>
#include <qvaluelist.h>
#include <qstringlist.h>
#include <qdom.h>


/**
 * @short ReplayGainPlugins
 * @author Daniel Faust <daniel@kaligames.de>
 * @version 0.1
 */
class ReplayGainPlugins
{
public:
    ReplayGainPlugins();

    enum Level
    {
        Full, Most, Basic
    };

private:
    struct Test
    {
        bool enabled;
        QString param;
        QString output_yes;
        QString output_no;
    };

    struct Gain
    {
        Level level;
        QString bin;
        QString param;
        QString silent_param;
        QString track;
        QString force;
        QString album;
        QString remove;
        QStringList formats;
        QString mime_types;
        uint min_version;
        uint max_version;
        Test test;
    };

    struct Info
    {
        int version; // v0.2.1 = 201, v11.3 = 110300
        QString name;
        QString author;
        QString about;
        QString short_info;
    };

public:
    class PluginStructure
    {
    public:
        Info info;
        Gain replaygain;
        QString inFiles;
        QString file_name;

        /*
        input:
            %i - input file
            %t - track value
            %a - album value

        output:
            %i - input file name
            %o - output file name
        */

        PluginStructure();
        PluginStructure(QString name);
        ~PluginStructure();
    };

    typedef QValueList<PluginStructure> PluginStructureList;

    PluginStructureList plugins;
    QStringList openFiles;

    void load();
    void reload();
    void unload(QString);
    void remove(QString);
    QStringList loadedPlugins();
    PluginStructure plugin(QString);
    PluginStructure pluginByFormat(QString);

private:
    QDomDocument domTree;

    bool loadFile(QString);

};

extern ReplayGainPlugins replayGainPlugins;

#endif // _REPLAYGAIN_PLUGINS_H_

