#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include "../src/object.h"

#define PI 3.14159265358979

int main()
{
	FILE *in, *out;
	char line[1000], s, *l;
	int n, i;
	double x, y, z;
	struct object obj;

	int rah, ram, decd, decm;
        double decs, ras, ra, dec;


	in=fopen("../utils/vla.J2000", "r");
	if(!in)
	{
		printf("../utils/vla.J2000 not found\n");
		return 0;
	}
	out=fopen("vla_cal.cat", "w");
	for(n=0;;n++)
	{
		fgets(line, 999, in);
		if(feof(in)) break;

		for(i = 0; i < strlen(line); i++) if(line[i] == 'J') break;
		if(i == strlen(line)) continue;

		l = line+i+9;
		sscanf(l, "%dh%dm%lfs",&rah, &ram, &ras);

		s = line[i+26];

		l = line+i+27;
		sscanf(l, "%dd%d\'%lf\"", &decd, &decm, &decs);

		ra  = rah + (double)ram/60.0 + ras/3600.0;
                dec = decd + (double)decm/60.0 + (double)decs/3600.0;

		if(s == '-') dec = -dec;

		ra = -ra*PI/12.0;
		dec = dec*PI/180.0;

		x = cos(ra)*cos(dec);
		y = sin(ra)*cos(dec);
		z = sin(dec);

		obj.x = (long)(x*(double)(1<<30));
                obj.y = (long)(y*(double)(1<<30));
                obj.z = (long)(z*(double)(1<<30));
		obj.type=65;
                obj.icon = 0;
		if(ra == 0.0 && dec == 0.0) obj.mask = 0x8F;
                else obj.mask = 0x0F;

		fwrite(&obj, 1, sizeof(obj), out);
	}

	fclose(in);
	fclose(out);
	printf("%d sources loaded\n", n);

	return 0;
}
