/*
 * Copyright (c) 2005-2007 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package org.jvnet.substance;

import java.awt.*;

import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.title.*;

/**
 * Delegate for painting gradient backgrounds.
 * 
 * @author Kirill Grouchnikov
 */
public class SubstanceGradientBackgroundDelegate {
	/**
	 * Classic title painter - to improve rendering time.
	 */
	private SubstanceTitlePainter classicTitlePainter;

	/**
	 * Creates a new gradien background delegate.
	 */
	public SubstanceGradientBackgroundDelegate() {
		this.classicTitlePainter = new ClassicTitlePainter();
	}

	/**
	 * Updates the specified component with the background that matches the
	 * provided parameters.
	 * 
	 * @param g
	 *            Graphic context.
	 * @param c
	 *            Component.
	 * @param width
	 *            Background width.
	 * @param height
	 *            Background height.
	 * @param theme
	 *            Theme for the background.
	 * @param borderAlpha
	 *            Border alpha.
	 */
	public void update(Graphics g, Component c, int width, int height,
			SubstanceTheme theme, float borderAlpha) {
		if (!c.isShowing())
			return;
		// fix for bug 65
		if ((width <= 0) || (height <= 0))
			return;
		synchronized (c) {
			// SubstanceImageCreator.paintRectangularBackground(g, 0, 0, width,
			// height, colorScheme, hasDarkBorder, false);
			SubstanceTitlePainter titlePainter = SubstanceLookAndFeel
					.getCurrentTitlePainter();
			if (titlePainter instanceof SubstanceHeaderPainter) {
				// if (!(c.getParent() instanceof JMenuBar)) {
				titlePainter = ((SubstanceHeaderPainter) titlePainter)
						.getSecondaryPainter();
				// }
			}
			if (titlePainter instanceof FlatTitlePainter)
				titlePainter = new ClassicTitlePainter();
			Graphics2D graphics = (Graphics2D) g.create(0, 0, width, height);
			titlePainter.paintTitleBackground(graphics, c, width, height, 0,
					width, theme, borderAlpha);
			// SubstanceImageCreator.paintRectangularBackground(g, rect.x,
			// rect.y,
			// rect.width, rect.height, colorScheme, hasDarkBorder, false);
			graphics.dispose();
		}
	}

	/**
	 * Updates the specified component with the background that matches the
	 * provided parameters.
	 * 
	 * @param g
	 *            Graphic context.
	 * @param c
	 *            Component.
	 * @param rect
	 *            Background rectangle.
	 * @param theme
	 *            Theme for the background.
	 * @param borderAlpha
	 *            Border alpha.
	 */
	public void update(Graphics g, Component c, Rectangle rect,
			SubstanceTheme theme, float borderAlpha) {
		// fix for bug 65
		if ((rect.width <= 0) || (rect.height <= 0))
			return;
		// synchronized (c) {
		// SubstanceLookAndFeel
		// .getCurrentTitlePainter();
		Graphics2D graphics = (Graphics2D) g.create(rect.x, rect.y, rect.width,
				rect.height);
		this.classicTitlePainter.paintTitleBackground(graphics, c, rect.width,
				rect.height, 0, rect.width, theme, borderAlpha);
		// SubstanceImageCreator.paintRectangularBackground(g, rect.x,
		// rect.y,
		// rect.width, rect.height, colorScheme, hasDarkBorder, false);
		graphics.dispose();
		// }
	}
}
