/*
 * Copyright (c) 2005-2007 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package org.jvnet.substance.plugin;

import java.util.HashSet;
import java.util.Set;

import org.jvnet.substance.watermark.*;

/**
 * Core plugin for watermarks. See
 * {@link org.jvnet.substance.plugin.SubstanceWatermarkPlugin} interface. This
 * class is <b>for internal use only</b>.
 * 
 * @author Kirill Grouchnikov.
 */
public class BaseWatermarkPlugin implements SubstanceWatermarkPlugin {
	/**
	 * Creates info object on a single watermark.
	 * 
	 * @param displayName
	 *            Watermark display name.
	 * @param watermarkClass
	 *            Watermark class.
	 * @param isDefault
	 *            Indication whether the specified watermark is default.
	 * @return Info object on the specified watermark.
	 */
	private static WatermarkInfo create(String displayName,
			Class<?> watermarkClass, boolean isDefault) {
		WatermarkInfo result = new WatermarkInfo(displayName, watermarkClass
				.getName());
		result.setDefault(isDefault);
		return result;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.plugin.SubstanceWatermarkPlugin#getWatermarks()
	 */
	public Set<WatermarkInfo> getWatermarks() {
		Set<WatermarkInfo> result = new HashSet<WatermarkInfo>();
		result.add(create(SubstanceStripeWatermark.getName(),
				SubstanceStripeWatermark.class, false));
		result.add(create(SubstanceBinaryWatermark.getName(),
				SubstanceBinaryWatermark.class, false));
		result.add(create(SubstanceBubblesWatermark.getName(),
				SubstanceBubblesWatermark.class, false));
		result.add(create(SubstanceCrosshatchWatermark.getName(),
				SubstanceCrosshatchWatermark.class, false));
		result.add(create(SubstanceKatakanaWatermark.getName(),
				SubstanceKatakanaWatermark.class, false));
		result.add(create(SubstanceLatchWatermark.getName(),
				SubstanceLatchWatermark.class, false));
		result.add(create(SubstanceMetalWallWatermark.getName(),
				SubstanceMetalWallWatermark.class, false));
		result.add(create(SubstanceMosaicWatermark.getName(),
				SubstanceMosaicWatermark.class, false));
		result.add(create(SubstanceNullWatermark.getName(),
				SubstanceNullWatermark.class, false));
		result.add(create(SubstanceNoneWatermark.getName(),
				SubstanceNoneWatermark.class, false));
		result.add(create(SubstanceMazeWatermark.getName(),
				SubstanceMazeWatermark.class, false));
		result.add(create(SubstanceWoodWatermark.getName(),
				SubstanceWoodWatermark.class, false));
		result.add(create(SubstanceMagneticFieldWatermark.getName(),
				SubstanceMagneticFieldWatermark.class, false));
		result.add(create(SubstanceFabricWatermark.getName(),
				SubstanceFabricWatermark.class, false));
		result.add(create(SubstanceMarbleVeinWatermark.getName(),
				SubstanceMarbleVeinWatermark.class, false));
		result.add(create(SubstancePlanktonWatermark.getName(),
				SubstancePlanktonWatermark.class, false));
		result.add(create(SubstanceCopperplateEngravingWatermark.getName(),
				SubstanceCopperplateEngravingWatermark.class, false));
		// result.add(create(SubstanceGenericNoiseWatermark.getName(),
		// SubstanceGenericNoiseWatermark.class, false));
		return result;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.plugin.SubstanceWatermarkPlugin#getDefaultWatermarkClassName()
	 */
	public String getDefaultWatermarkClassName() {
		return null;
	}
}
