/*
 * Copyright (c) 2005-2007 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package org.jvnet.substance.skin;

import java.awt.Color;

import org.jvnet.substance.border.FlatBorderPainter;
import org.jvnet.substance.button.ClassicButtonShaper;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.painter.SimplisticSoftBorderReverseGradientPainter;
import org.jvnet.substance.painter.SubduedGradientPainter;
import org.jvnet.substance.theme.SubstanceComplexTheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.theme.SubstanceTheme.ThemeKind;
import org.jvnet.substance.title.ArcHeaderPainter;
import org.jvnet.substance.title.MarbleNoiseHeaderPainter;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.watermark.SubstanceNullWatermark;

/**
 * <code>Nebula</code> skin. This class is part of officially supported API.
 * 
 * @author Kirill Grouchnikov
 * @since version 4.0
 */
public class NebulaSkin extends SubstanceAbstractSkin {
	/**
	 * Display name for <code>this</code> skin.
	 */
	public static String NAME = "Nebula";

	/**
	 * Color scheme for active visual state.
	 * 
	 * @author Kirill Grouchnikov
	 */
	protected static class ActiveScheme implements ColorScheme {
		/**
		 * The main ultra-light color.
		 */
		private static final Color mainUltraLightColor = Color
				.decode("#F6F8FA");

		/**
		 * The main extra-light color.
		 */
		private static final Color mainExtraLightColor = Color
				.decode("#DFE6ED");

		/**
		 * The main light color.
		 */
		private static final Color mainLightColor = Color.decode("#C1D6E9");

		/**
		 * The main medium color.
		 */
		private static final Color mainMidColor = Color.decode("#A3B8CB");

		/**
		 * The main dark color.
		 */
		private static final Color mainDarkColor = Color.decode("#62778A");

		/**
		 * The main ultra-dark color.
		 */
		private static final Color mainUltraDarkColor = Color.decode("#42576A");

		/**
		 * The foreground color.
		 */
		private static final Color foregroundColor = Color.decode("#000000");

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getForegroundColor()
		 */
		public Color getForegroundColor() {
			return ActiveScheme.foregroundColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getUltraLightColor()
		 */
		public Color getUltraLightColor() {
			return ActiveScheme.mainUltraLightColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getExtraLightColor()
		 */
		public Color getExtraLightColor() {
			return ActiveScheme.mainExtraLightColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getLightColor()
		 */
		public Color getLightColor() {
			return ActiveScheme.mainLightColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getMidColor()
		 */
		public Color getMidColor() {
			return ActiveScheme.mainMidColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getDarkColor()
		 */
		public Color getDarkColor() {
			return ActiveScheme.mainDarkColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getUltraDarkColor()
		 */
		public Color getUltraDarkColor() {
			return ActiveScheme.mainUltraDarkColor;
		}
	}

	/**
	 * Color scheme for default visual state.
	 * 
	 * @author Kirill Grouchnikov
	 */
	protected static class DefaultScheme implements ColorScheme {
		/**
		 * The main ultra-light color.
		 */
		private static final Color mainUltraLightColor = Color
				.decode("#FBFBFC");

		/**
		 * The main extra-light color.
		 */
		private static final Color mainExtraLightColor = Color
				.decode("#F4F7FC");

		/**
		 * The main light color.
		 */
		private static final Color mainLightColor = Color.decode("#F1F2F4");

		/**
		 * The main medium color.
		 */
		private static final Color mainMidColor = Color.decode("#D6D9DF");

		/**
		 * The main dark color.
		 */
		private static final Color mainDarkColor = Color.decode("#95989E");

		/**
		 * The main ultra-dark color.
		 */
		private static final Color mainUltraDarkColor = Color.decode("#75787E");

		/**
		 * The foreground color.
		 */
		private static final Color foregroundColor = Color.decode("#2A2E36");

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getForegroundColor()
		 */
		public Color getForegroundColor() {
			return DefaultScheme.foregroundColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getUltraLightColor()
		 */
		public Color getUltraLightColor() {
			return DefaultScheme.mainUltraLightColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getExtraLightColor()
		 */
		public Color getExtraLightColor() {
			return DefaultScheme.mainExtraLightColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getLightColor()
		 */
		public Color getLightColor() {
			return DefaultScheme.mainLightColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getMidColor()
		 */
		public Color getMidColor() {
			return DefaultScheme.mainMidColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getDarkColor()
		 */
		public Color getDarkColor() {
			return DefaultScheme.mainDarkColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getUltraDarkColor()
		 */
		public Color getUltraDarkColor() {
			return DefaultScheme.mainUltraDarkColor;
		}
	}

	/**
	 * Color scheme for default visual state.
	 * 
	 * @author Kirill Grouchnikov
	 */
	protected static class DisabledScheme implements ColorScheme {
		/**
		 * The main ultra-light color.
		 */
		private static final Color mainUltraLightColor = Color
				.decode("#E3EFE9");

		/**
		 * The main extra-light color.
		 */
		private static final Color mainExtraLightColor = Color
				.decode("#DFE2E6");

		/**
		 * The main light color.
		 */
		private static final Color mainLightColor = Color.decode("#DADDE3");

		/**
		 * The main medium color.
		 */
		private static final Color mainMidColor = Color.decode("#D6D9DF");

		/**
		 * The main dark color.
		 */
		private static final Color mainDarkColor = Color.decode("#C9CCD2");

		/**
		 * The main ultra-dark color.
		 */
		private static final Color mainUltraDarkColor = Color.decode("#BCBFC5");

		/**
		 * The foreground color.
		 */
		private static final Color foregroundColor = Color.decode("#848B98");

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getForegroundColor()
		 */
		public Color getForegroundColor() {
			return DisabledScheme.foregroundColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getUltraLightColor()
		 */
		public Color getUltraLightColor() {
			return DisabledScheme.mainUltraLightColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getExtraLightColor()
		 */
		public Color getExtraLightColor() {
			return DisabledScheme.mainExtraLightColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getLightColor()
		 */
		public Color getLightColor() {
			return DisabledScheme.mainLightColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getMidColor()
		 */
		public Color getMidColor() {
			return DisabledScheme.mainMidColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getDarkColor()
		 */
		public Color getDarkColor() {
			return DisabledScheme.mainDarkColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getUltraDarkColor()
		 */
		public Color getUltraDarkColor() {
			return DisabledScheme.mainUltraDarkColor;
		}
	}

	/**
	 * Color scheme for {@link ComponentState#ROLLOVER_UNSELECTED} state.
	 * 
	 * @author Kirill Grouchnikov
	 */
	protected static class RolloverUnselectedScheme implements ColorScheme {
		/**
		 * The main ultra-light color.
		 */
		private static final Color mainUltraLightColor = Color
				.decode("#FFFFFF");

		/**
		 * The main extra-light color.
		 */
		private static final Color mainExtraLightColor = Color
				.decode("#FDFDFE");

		/**
		 * The main light color.
		 */
		private static final Color mainLightColor = Color.decode("#F7F8FA");

		/**
		 * The main medium color.
		 */
		private static final Color mainMidColor = Color.decode("#E9ECF2");

		/**
		 * The main dark color.
		 */
		private static final Color mainDarkColor = Color.decode("#7A7E86");

		/**
		 * The main ultra-dark color.
		 */
		private static final Color mainUltraDarkColor = Color.decode("#55585E");

		/**
		 * The foreground color.
		 */
		private static final Color foregroundColor = Color.decode("#2A2E36");

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getForegroundColor()
		 */
		public Color getForegroundColor() {
			return RolloverUnselectedScheme.foregroundColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getUltraLightColor()
		 */
		public Color getUltraLightColor() {
			return RolloverUnselectedScheme.mainUltraLightColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getExtraLightColor()
		 */
		public Color getExtraLightColor() {
			return RolloverUnselectedScheme.mainExtraLightColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getLightColor()
		 */
		public Color getLightColor() {
			return RolloverUnselectedScheme.mainLightColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getMidColor()
		 */
		public Color getMidColor() {
			return RolloverUnselectedScheme.mainMidColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getDarkColor()
		 */
		public Color getDarkColor() {
			return RolloverUnselectedScheme.mainDarkColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getUltraDarkColor()
		 */
		public Color getUltraDarkColor() {
			return RolloverUnselectedScheme.mainUltraDarkColor;
		}
	}

	/**
	 * Color scheme for {@link ComponentState#ROLLOVER_SELECTED} state.
	 * 
	 * @author Kirill Grouchnikov
	 */
	protected static class RolloverSelectedTheme implements ColorScheme {
		/**
		 * The main ultra-light color.
		 */
		private static final Color mainUltraLightColor = Color
				.decode("#F8FAFC");

		/**
		 * The main extra-light color.
		 */
		private static final Color mainExtraLightColor = Color
				.decode("#E8FDFF");

		/**
		 * The main light color.
		 */
		private static final Color mainLightColor = Color.decode("#D4E9FC");

		/**
		 * The main medium color.
		 */
		private static final Color mainMidColor = Color.decode("#B6CBDE");

		/**
		 * The main dark color.
		 */
		private static final Color mainDarkColor = Color.decode("#3B556D");

		/**
		 * The main ultra-dark color.
		 */
		private static final Color mainUltraDarkColor = Color.decode("#00051D");

		/**
		 * The foreground color.
		 */
		private static final Color foregroundColor = Color.decode("#000000");

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getForegroundColor()
		 */
		public Color getForegroundColor() {
			return RolloverSelectedTheme.foregroundColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getUltraLightColor()
		 */
		public Color getUltraLightColor() {
			return RolloverSelectedTheme.mainUltraLightColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getExtraLightColor()
		 */
		public Color getExtraLightColor() {
			return RolloverSelectedTheme.mainExtraLightColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getLightColor()
		 */
		public Color getLightColor() {
			return RolloverSelectedTheme.mainLightColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getMidColor()
		 */
		public Color getMidColor() {
			return RolloverSelectedTheme.mainMidColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getDarkColor()
		 */
		public Color getDarkColor() {
			return RolloverSelectedTheme.mainDarkColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getUltraDarkColor()
		 */
		public Color getUltraDarkColor() {
			return RolloverSelectedTheme.mainUltraDarkColor;
		}
	}

	/**
	 * Color scheme for {@link ComponentState#PRESSED_SELECTED} and
	 * {@link ComponentState#PRESSED_UNSELECTED} states.
	 * 
	 * @author Kirill Grouchnikov
	 */
	protected static class PressedTheme implements ColorScheme {
		/**
		 * The main ultra-light color.
		 */
		private static final Color mainUltraLightColor = Color
				.decode("#8FA9C0");

		/**
		 * The main extra-light color.
		 */
		private static final Color mainExtraLightColor = Color
				.decode("#7695B2");

		/**
		 * The main light color.
		 */
		private static final Color mainLightColor = Color.decode("#5B89B4");

		/**
		 * The main medium color.
		 */
		private static final Color mainMidColor = Color.decode("#33628C");

		/**
		 * The main dark color.
		 */
		private static final Color mainDarkColor = Color.decode("#1C3851");

		/**
		 * The main ultra-dark color.
		 */
		private static final Color mainUltraDarkColor = Color.decode("#000000");

		/**
		 * The foreground color.
		 */
		private static final Color foregroundColor = Color.decode("#FFFFFF");

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getForegroundColor()
		 */
		public Color getForegroundColor() {
			return PressedTheme.foregroundColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getUltraLightColor()
		 */
		public Color getUltraLightColor() {
			return PressedTheme.mainUltraLightColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getExtraLightColor()
		 */
		public Color getExtraLightColor() {
			return PressedTheme.mainExtraLightColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getLightColor()
		 */
		public Color getLightColor() {
			return PressedTheme.mainLightColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getMidColor()
		 */
		public Color getMidColor() {
			return PressedTheme.mainMidColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getDarkColor()
		 */
		public Color getDarkColor() {
			return PressedTheme.mainDarkColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getUltraDarkColor()
		 */
		public Color getUltraDarkColor() {
			return PressedTheme.mainUltraDarkColor;
		}
	}

	/**
	 * Creates a new <code>Nebula</code> skin.
	 */
	public NebulaSkin() {
		SubstanceTheme activeTheme = new SubstanceTheme(new ActiveScheme(),
				"Nebula Active", ThemeKind.COLD);
		SubstanceTheme defaultTheme = new SubstanceTheme(new DefaultScheme(),
				"Nebula Default", ThemeKind.COLD);
		SubstanceTheme rolloverUnselectedTheme = new SubstanceTheme(
				new RolloverUnselectedScheme(), "Nebula Rollover Unselected",
				ThemeKind.COLD);
		SubstanceTheme pressedTheme = new SubstanceTheme(new PressedTheme(),
				"Nebula Pressed", ThemeKind.DARK);
		SubstanceTheme rolloverSelectedTheme = new SubstanceTheme(
				new RolloverSelectedTheme(), "Nebula Rollover Selected",
				ThemeKind.COLD);
		SubstanceTheme disabledTheme = new SubstanceTheme(new DisabledScheme(),
				"Nebula Disabled", ThemeKind.COLD);
		SubstanceTheme activeTitleTheme = activeTheme.getDefaultTheme();

		SubstanceComplexTheme theme = new SubstanceComplexTheme(NAME,
				ThemeKind.COLD, activeTheme, defaultTheme, disabledTheme,
				activeTitleTheme);
		theme.registerComponentStateTheme(rolloverUnselectedTheme, false,
				ComponentState.ROLLOVER_UNSELECTED);
		theme.registerComponentStateTheme(rolloverSelectedTheme, false,
				ComponentState.ROLLOVER_SELECTED);
		theme.registerComponentStateTheme(pressedTheme, true,
				ComponentState.PRESSED_SELECTED,
				ComponentState.PRESSED_UNSELECTED);

		theme.registerComponentHighlightStateTheme(pressedTheme, 0.6f,
				ComponentState.ROLLOVER_UNSELECTED);
		theme.registerComponentHighlightStateTheme(pressedTheme, 0.8f,
				ComponentState.SELECTED);
		theme.registerComponentHighlightStateTheme(pressedTheme, 0.95f,
				ComponentState.ROLLOVER_SELECTED);
		theme.registerComponentHighlightStateTheme(pressedTheme, 0.8f,
				ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);

		theme
				.setNonActivePainter(new SimplisticSoftBorderReverseGradientPainter());
		theme.setSelectedTabFadeStart(0.1);
		theme.setSelectedTabFadeEnd(0.3);
		this.theme = theme;

		this.shaper = new ClassicButtonShaper();
		this.watermark = new SubstanceNullWatermark();
		this.gradientPainter = new SubduedGradientPainter();
		// this.titlePainter = new FlatTitlePainter();

		MarbleNoiseHeaderPainter titlePainter = new MarbleNoiseHeaderPainter(
				false, true);
		titlePainter.setPaintingToolbarDropShadows(true);
		titlePainter.setPaintingSeparators(true);
		titlePainter.setBaseTitlePainter(new ArcHeaderPainter());
		titlePainter.setTextureAlpha(0.3f);
		this.titlePainter = titlePainter;

		this.borderPainter = new FlatBorderPainter();
		// this.tabBackgroundComposite = new
		// AlphaControlBackgroundComposite(0.75f);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.skin.SubstanceSkin#getDisplayName()
	 */
	public String getDisplayName() {
		return NAME;
	}
}
