/*
 * Copyright (c) 2005-2007 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package org.jvnet.substance.theme;

import java.awt.Color;

import org.jvnet.substance.color.InvertedColorScheme;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

/**
 * Inverted theme. Inverted theme is based on some original theme, switching the
 * dark colors by light colors and inverting the foreground color. This class is
 * part of officially supported API.
 * 
 * @author Kirill Grouchnikov
 * @see InvertedColorScheme
 */
public class SubstanceInvertedTheme extends SubstanceWrapperTheme {
	/**
	 * Creates a new inverted theme. <b>Do not</b> use this constructor
	 * directly, use {@link SubstanceTheme#invert()} instead.
	 * 
	 * @param substanceTheme
	 *            The original theme.
	 */
	public SubstanceInvertedTheme(SubstanceTheme substanceTheme) {
		super(substanceTheme, new InvertedColorScheme(substanceTheme
				.getColorScheme()), "Inverted "
				+ substanceTheme.getDisplayName(), ThemeKind.INVERTED);
		this.originalTheme = substanceTheme;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.theme.SubstanceTheme#invert()
	 */
	@Override
	public SubstanceTheme invert() {
		return this.originalTheme;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.theme.SubstanceTheme#negate()
	 */
	@Override
	public SubstanceTheme negate() {
		throw new UnsupportedOperationException(
				"Negating an inverted theme is not supported");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.theme.SubstanceTheme#getWatermarkStampColor()
	 */
	@Override
	public Color getWatermarkStampColor() {
		return SubstanceCoreUtilities.isThemeDark(this) ? SubstanceColorUtilities
				.getAlphaColor(this.getColorScheme().getDarkColor(), 60)
				: SubstanceColorUtilities.getAlphaColor(this.getColorScheme()
						.getUltraLightColor(), 25);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.theme.SubstanceTheme#saturate(double, boolean)
	 */
	@Override
	public SubstanceTheme saturate(double saturateFactor,
			boolean toSaturateEverything) {
		return this.originalTheme
				.saturate(saturateFactor, toSaturateEverything).invert();
		// return new SubstanceInvertedTheme(this.originalTheme
		// .saturate(saturateFactor));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.theme.SubstanceTheme#tint(double)
	 */
	@Override
	public SubstanceTheme tint(double tintFactor) {
		return this.originalTheme.tint(tintFactor).invert();
		// return new
		// SubstanceInvertedTheme(this.originalTheme.tint(tintFactor));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.theme.SubstanceTheme#tone(double)
	 */
	@Override
	public SubstanceTheme tone(double toneFactor) {
		return this.originalTheme.tone(toneFactor).invert();
		// return new
		// SubstanceInvertedTheme(this.originalTheme.tone(toneFactor));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.theme.SubstanceTheme#shade(double)
	 */
	@Override
	public SubstanceTheme shade(double shadeFactor) {
		return this.originalTheme.shade(shadeFactor).invert();
		// return new
		// SubstanceInvertedTheme(this.originalTheme.shade(shadeFactor));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.theme.SubstanceTheme#hueShift(double)
	 */
	@Override
	public SubstanceTheme hueShift(double hueShiftFactor) {
		return this.originalTheme.hueShift(hueShiftFactor).invert();
	}

	// /*
	// * (non-Javadoc)
	// *
	// * @see org.jvnet.substance.theme.SubstanceTheme#getDefaultTheme()
	// */
	// @Override
	// public SubstanceTheme getDefaultTheme() {
	// if (this.defaultTheme == null)
	// this.defaultTheme = this.originalTheme.getDefaultTheme().invert();
	// return this.defaultTheme;
	// }
	//
	// /*
	// * (non-Javadoc)
	// *
	// * @see org.jvnet.substance.theme.SubstanceTheme#getDisabledTheme()
	// */
	// @Override
	// public SubstanceTheme getDisabledTheme() {
	// if (this.disabledTheme == null)
	// this.disabledTheme = this.originalTheme.getDisabledTheme().invert();
	// return this.disabledTheme;
	// }
}
