/*
 * Copyright (c) 2005-2007 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package org.jvnet.substance.title;

import org.jvnet.substance.painter.noise.NoiseFactory;
import org.jvnet.substance.theme.SubstanceAquaTheme;
import org.jvnet.substance.theme.SubstanceTheme;

/**
 * Implementation of {@link SubstanceHeaderPainter} that uses marble noise
 * painting on title panes.
 * 
 * @author Kirill Grouchnikov
 * @since version 4.0
 */
public class MarbleNoiseHeaderPainter extends ImageWrapperHeaderPainter {
	/**
	 * The display name for the title painters of this class.
	 */
	public static final String DISPLAY_NAME = "Marble Noise";

	/**
	 * Creates a new marble noise header painter that is used to paint title
	 * panes, menubars <b>and</b> toolbars.
	 */
	public MarbleNoiseHeaderPainter() {
		this(true, true);
	}

	/**
	 * Creates a new marble noise header painter
	 * 
	 * @param isPaintingToolbars
	 *            If <code>true</code>, this painter will be used to paint
	 *            toolbars in addition to painting title panes and menubars.
	 * @param isPaintingGeneralDecorationAreas
	 *            If <code>true</code>, this painter will be used to paint
	 *            additional general decoration areas.
	 */
	public MarbleNoiseHeaderPainter(boolean isPaintingToolbars,
			boolean isPaintingGeneralDecorationAreas) {
		super(isPaintingToolbars, isPaintingGeneralDecorationAreas);
		SubstanceTheme theme = new SubstanceAquaTheme();
		this.singleTile = NoiseFactory.getNoiseImage(theme, theme, 400, 400,
				0.8, 0.8, false, null, true, true);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.painter.SubstanceGradientPainter#getDisplayName()
	 */
	public String getDisplayName() {
		return DISPLAY_NAME;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.title.ImageWrapperHeaderPainter#getSecondaryPainter()
	 */
	@Override
	public SubstanceTitlePainter getSecondaryPainter() {
		if (this.secondaryTitlePainter == null) {
			if (this.baseTitlePainter instanceof ArcHeaderPainter) {
				this.secondaryTitlePainter = new MarbleNoiseHeaderPainter(
						this.isPaintingToolbars,
						this.isPaintingGeneralDecorationAreas);
				this.secondaryTitlePainter
						.setTextureAlpha(this.textureAlpha * 0.7f);
				this.secondaryTitlePainter
						.setBaseTitlePainter(((ArcHeaderPainter) this.baseTitlePainter)
								.getSecondaryPainter());
			}
		}
		if (this.secondaryTitlePainter != null)
			return this.secondaryTitlePainter;
		return super.getSecondaryPainter();
	}
}
