/*
 * Copyright (c) 2005-2007 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package org.jvnet.substance.title;

import java.awt.*;

import javax.swing.JToolBar;

import org.jvnet.substance.theme.SubstanceTheme;

/**
 * Base interface for title painters that paint menubars and toolbars (in
 * addition to painting the title panes).
 * 
 * @author kirillg
 */
public interface SubstanceHeaderPainter extends SubstanceTitlePainter {
	/**
	 * Paints background of non-title pane content (such as menubars and
	 * toolbars).
	 * 
	 * @param graphics
	 *            Graphics context.
	 * @param parent
	 *            Component parent.
	 * @param comp
	 *            Component.
	 * @param width
	 *            Area width to paint.
	 * @param height
	 *            Area height to paint.
	 * @param theme
	 *            Theme to use for painting.
	 * @param hasDarkBorder
	 *            Indicates whether a border should be added to the resulting
	 *            painting.
	 */
	public void paintExtraBackground(Graphics2D graphics, Container parent,
			Component comp, int width, int height, SubstanceTheme theme,
			boolean hasDarkBorder);

	/**
	 * Returns the secondary painter which is used for painting areas that do
	 * not have the painting of title pane (currently used for menu items).
	 * 
	 * @return The secondary painter.
	 */
	public SubstanceTitlePainter getSecondaryPainter();

	/**
	 * Returns indication whether this painter is used to paint the background
	 * of the specified container.
	 * 
	 * @param cont
	 *            Container.
	 * @return <code>true</code> if this painter is used to paint the
	 *         background of the specified container, <code>false</code>
	 *         otherwise.
	 */
	public boolean isPaintingContainer(Container cont);

	/**
	 * Returns indication whether this painter will cause drop shadows to appear
	 * on the top portion of the toolbars that are <b>not</b> painted by this
	 * painter (that is, this method is relevant only when
	 * {@link #isPaintingContainer()} returns <code>false</code> when called
	 * with {@link JToolBar} parameter).
	 * 
	 * @return <code>true</code> if this painter will cause drop shadows to
	 *         appear on the top portion of the toolbars that are <b>not</b>
	 *         painted by this painter, <code>false</code> otherwise.
	 */
	public boolean isPaintingToolbarDropShadows();
}
