package test;

import java.awt.*;
import java.awt.image.BufferedImage;

import javax.swing.*;

import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.theme.SubstanceAquaTheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.ComponentState;

public class CloseIcon extends JFrame {
	public CloseIcon() {
		this.add(new CPanel(), BorderLayout.CENTER);
		setSize(800, 400);
		setLocationRelativeTo(null);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}

	public static class CPanel extends JPanel {
		@Override
		protected void paintComponent(Graphics g) {
			g.setColor(Color.lightGray.brighter());
			g.fillRect(0, 0, getWidth(), getHeight());
			SubstanceTheme st = new SubstanceAquaTheme();
			int x = 0;
			for (int i = 12; i < 36; i++) {
				Icon icon = SubstanceImageCreator.getCloseIcon(i, st);
				icon.paintIcon(CPanel.this, g, x, 100);
				g.setColor(Color.blue);
				g.drawRect(x, 100, icon.getIconWidth(), icon.getIconHeight());
				icon = SubstanceImageCreator.getMaximizeIcon(i, st);
				icon.paintIcon(CPanel.this, g, x, 140);
				icon = SubstanceImageCreator.getMinimizeIcon(i, st);
				icon.paintIcon(CPanel.this, g, x, 180);
				x += (i+2);
			}
		}
	}

	public static void main(String[] args) throws Exception {
		UIManager.setLookAndFeel(new SubstanceLookAndFeel());
		new CloseIcon().setVisible(true);
	}

}
