package test;

import java.awt.BorderLayout;
import java.awt.Color;

import javax.swing.*;

import org.jvnet.substance.SubstanceLookAndFeel;

public class TabbedPane extends JFrame {
	public TabbedPane() {
		super("Some simple text");
		this.setLayout(new BorderLayout());
		JTabbedPane tabbedPane = new JTabbedPane(JTabbedPane.TOP,
				JTabbedPane.SCROLL_TAB_LAYOUT);

		for (int i = 0; i < 20; i++) {
			tabbedPane.add(new JPanel(), "FOO" + i);
			tabbedPane.setBackgroundAt(i, Color.blue);
		}

		this.add(tabbedPane);

		this.setSize(300, 200);
		this.setLocationRelativeTo(null);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}

	public static void main(String[] args) throws Exception {
		JFrame.setDefaultLookAndFeelDecorated(true);
		UIManager.setLookAndFeel(new SubstanceLookAndFeel());
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				new TabbedPane().setVisible(true);
			}
		});
	}
}
