package test;

import java.awt.*;

import javax.swing.*;

import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.theme.SubstanceAquaTheme;
import org.jvnet.substance.theme.SubstanceTheme;

public class TreeIcon extends JFrame {
	public TreeIcon() {
		this.add(new CPanel(), BorderLayout.CENTER);
		setSize(800, 400);
		setLocationRelativeTo(null);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}

	public static class CPanel extends JPanel {
		@Override
		protected void paintComponent(Graphics g) {
			g.setColor(Color.lightGray.brighter());
			g.fillRect(0, 0, getWidth(), getHeight());
			SubstanceTheme st = new SubstanceAquaTheme();
			int x = 0;
			for (int i = 12; i < 36; i++) {
				Icon icon = new ImageIcon(SubstanceImageCreator.getTreeIcon(i,
						null, st.getDefaultColorScheme(), false, true));
				icon.paintIcon(CPanel.this, g, x, 100);
				x += (i + 2);
			}
		}
	}

	public static void main(String[] args) throws Exception {
		UIManager.setLookAndFeel(new SubstanceLookAndFeel());
		new TreeIcon().setVisible(true);
	}

}
