/*
 * Copyright (c) 2005-2007 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package test.check;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.Map;

import javax.swing.*;
import javax.swing.border.EmptyBorder;

import org.jvnet.lafwidget.LafWidget;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.theme.*;
import org.jvnet.substance.theme.SubstanceTheme.ThemeKind;
import org.jvnet.substance.watermark.WatermarkChangeListener;
import org.jvnet.substance.watermark.WatermarkInfo;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.Sizes;

/**
 * Internal frame for the test application.
 * 
 * @author Kirill Grouchnikov
 */
public class SampleInternalFrame extends JInternalFrame {
	/**
	 * Creates the test internal frame.
	 */
	public SampleInternalFrame() {
		this.setLayout(new BorderLayout());
		JTabbedPane tabbed = new JTabbedPane();
		this.add(tabbed, BorderLayout.CENTER);

		tabbed.addTab("Regular", new JPanel());

		JPanel samplePanel = new JPanel(new BorderLayout());
		FormLayout lm = new FormLayout("fill:default:grow(1), 4dlu,"
				+ "fill:default:grow(1)", "");
		DefaultFormBuilder builder = new DefaultFormBuilder(lm);
		builder.setLineGapSize(Sizes.pixel(1));
		builder.setBorder(new EmptyBorder(2, 2, 2, 2));
		// lm.setColumnGroups(new int[][] { { 3, 5, 7 } });

		// TwoColumnPanel stuff = new TwoColumnPanel();
		// stuff.setVerticalSpacing(4);
		// stuff.setHorizontalSpacing(0);

		JCheckBox cb1 = new JCheckBox("Enabled selected");
		cb1.setSelected(true);
		JCheckBox cb2 = new JCheckBox("Disabled selected");
		cb2.setSelected(true);
		cb2.setEnabled(false);
		JCheckBox cb3 = new JCheckBox("Enabled unselected");
		// cb3.setEnabled(false);
		JRadioButton rb1 = new JRadioButton("Enabled selected");
		rb1.setSelected(true);
		JRadioButton rb2 = new JRadioButton("Disabled selected");
		rb2.setSelected(true);
		rb2.setEnabled(false);
		JRadioButton rb3 = new JRadioButton("Enabled unselected");
		// rb3.setEnabled(false);

		builder.append(cb1, rb1);
		builder.append(cb2, rb2);
		builder.append(cb3, rb3);
		JComboBox combo = new JComboBox(new Object[] { "item1" });
		combo.setSelectedIndex(0);
		combo.setEditable(true);
		combo.putClientProperty(LafWidget.COMBO_BOX_USE_MODEL_ONLY,
				Boolean.TRUE);
		JTextField text = new JTextField("Text field");
		text.setEditable(false);
		builder.append(combo, text);
		JPanel contentPanel = builder.getPanel();
		contentPanel.setPreferredSize(new Dimension(contentPanel
				.getPreferredSize().width,
				contentPanel.getPreferredSize().height + 100));
		// contentPanel.setOpaque(false);
		contentPanel.setBorder(null);
		// stuff.setBorder(null);

		JScrollPane scroll = new JScrollPane(contentPanel,
				JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
				JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);

		scroll.setBorder(new EmptyBorder(0, 0, 0, 0));
		samplePanel.add(scroll, BorderLayout.CENTER);

		JPanel buttons = new JPanel(new FlowLayout(FlowLayout.RIGHT));
		JButton prev = new JButton("prev");
		JButton cancel = new JButton("cancel");
		cancel.setEnabled(false);
		JButton ok = new JButton("OK");
		ok.putClientProperty(SubstanceLookAndFeel.PAINT_ACTIVE_PROPERTY,
				Boolean.TRUE);
		buttons.add(prev);
		buttons.add(cancel);
		buttons.add(ok);

		samplePanel.add(buttons, BorderLayout.SOUTH);

		tabbed.addTab("Sample", samplePanel);
		tabbed.setSelectedComponent(samplePanel);
		tabbed.setOpaque(false);
		JMenuBar jmb = new JMenuBar();

		if (UIManager.getLookAndFeel() instanceof SubstanceLookAndFeel) {
			Map<String, ThemeInfo> allThemes = SubstanceLookAndFeel
					.getAllThemes();

			JMenu jmTheme = new JMenu("Theme");
			JMenu jmInvertedTheme = SubstanceLookAndFeel
					.toEnableInvertedThemes() ? new JMenu("Inverted theme")
					: null;

			ButtonGroup bgTheme = new ButtonGroup();
			for (Map.Entry<String, ThemeInfo> themeEntry : allThemes.entrySet()) {
				String themeName = themeEntry.getKey();
				final ThemeInfo themeInfo = themeEntry.getValue();
				final String themeClassName = themeInfo.getClassName();

				JRadioButtonMenuItem jmiTheme = new JRadioButtonMenuItem(
						themeName);
				try {
					Class<?> themeClass = Class.forName(themeClassName);
					SubstanceTheme theme = (SubstanceTheme) themeClass
							.newInstance();
					if (themeInfo.getThemeKind() == ThemeKind.INVERTED)
						theme = new SubstanceInvertedTheme(theme);
					jmiTheme.setIcon(SubstanceImageCreator.getThemeIcon(theme));
				} catch (Exception exc) {
					continue;
				}

				jmiTheme.addActionListener(new ActionListener() {
					public void actionPerformed(ActionEvent e) {
						try {
							if ((themeInfo.getThemeKind() == ThemeKind.INVERTED)
									|| (themeInfo.getThemeKind() == ThemeKind.NEGATED)) {
								SubstanceLookAndFeel.setCurrentTheme(themeInfo);
							} else {
								SubstanceLookAndFeel
										.setCurrentTheme(themeClassName);
							}
							// UIManager
							// .setLookAndFeel(new SubstanceLookAndFeel());
						} catch (Exception exc) {
							exc.printStackTrace();
						}
						for (Frame frame : Frame.getFrames())
							SwingUtilities.updateComponentTreeUI(frame);
					}
				});
				if (themeName
						.equals(SubstanceLookAndFeel.getCurrentThemeName())) {
					jmiTheme.setSelected(true);
				}
				bgTheme.add(jmiTheme);

				if (themeEntry.getValue().getThemeKind() == ThemeKind.INVERTED)
					jmInvertedTheme.add(jmiTheme);
				else
					jmTheme.add(jmiTheme);
			}

			jmb.add(jmTheme);
			if (jmInvertedTheme != null)
				jmb.add(jmInvertedTheme);

			JMenu jmWatermark = new JMenu("Watermark");

			ButtonGroup bgWatermark = new ButtonGroup();
			Map<String, WatermarkInfo> allWatermarks = SubstanceLookAndFeel
					.getAllWatermarks();
			for (Map.Entry<String, WatermarkInfo> watermarkEntry : allWatermarks
					.entrySet()) {
				String watermarkName = watermarkEntry.getKey();
				final String watermarkClassName = watermarkEntry.getValue()
						.getClassName();

				JRadioButtonMenuItem jmiWatermark = new JRadioButtonMenuItem(
						watermarkName);
				jmiWatermark.addActionListener(new ActionListener() {
					public void actionPerformed(ActionEvent e) {
						SubstanceLookAndFeel
								.setCurrentWatermark(watermarkClassName);
						for (Frame frame : Frame.getFrames())
							SwingUtilities.updateComponentTreeUI(frame);
					}
				});
				if (watermarkName.equals(SubstanceLookAndFeel
						.getCurrentWatermarkName())) {
					jmiWatermark.setSelected(true);
				}
				bgWatermark.add(jmiWatermark);
				jmWatermark.add(jmiWatermark);
			}

			jmWatermark.addSeparator();
		}

		JMenu jm1 = new JMenu("Menu1");
		jm1.setMnemonic('1');
		int mcount = 0;
		for (LinkedList<JMenuItem> miList : SampleMenuFactory
				.getTestMenuItems()) {
			if (mcount > 0) {
				if (mcount % 2 == 0)
					jm1.addSeparator();
				else
					jm1.add(new JSeparator());
			}
			for (JMenuItem menuItem : miList) {
				jm1.add(menuItem);
			}
			mcount++;
		}
		jmb.add(jm1);
		this.setJMenuBar(jmb);

		this.setClosable(true);
		this.setMaximizable(true);
		this.setIconifiable(true);
		this.setResizable(true);

		synchronize();
		SubstanceLookAndFeel
				.registerThemeChangeListener(new ThemeChangeListener() {
					public void themeChanged() {
						synchronize();
					}
				});
		SubstanceLookAndFeel
				.registerWatermarkChangeListener(new WatermarkChangeListener() {
					public void watermarkChanged() {
						synchronize();
					}
				});
		ok.requestFocusInWindow();
	}

	/**
	 * Synchronizes the frame icon with the current theme.
	 */
	protected void synchronize() {
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				setFrameIcon(new ImageIcon(SubstanceImageCreator
						.getBigHexaMarker(6, SubstanceLookAndFeel.getTheme())));
				setTitle(SubstanceLookAndFeel.getCurrentThemeName() + " / "
						+ SubstanceLookAndFeel.getCurrentWatermarkName());
			}
		});
	}
}
