/*
 * Copyright (c) 2005-2007 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package test.check;

import java.awt.*;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import java.util.Vector;

import javax.swing.*;

import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.theme.ThemeInfo;

/**
 * Test panel with theme selection combobox.
 * 
 * @author Kirill Grouchnikov
 */
public class ThemesPanel extends JPanel {
	/**
	 * Renderer for the combobox containing the theme list.
	 * 
	 * @author Kirill Grouchnikov
	 */
	protected static class ThemeComboRenderer extends JLabel implements
			ListCellRenderer {
		/**
		 * The current theme.
		 */
		protected SubstanceTheme currTheme;

		public Component getListCellRendererComponent(JList list, Object value,
				int index, boolean isSelected, boolean cellHasFocus) {
			SubstanceTheme theme = (SubstanceTheme) value;
			this.setBackground(theme.getColorScheme().getMidColor());
			this.setForeground(theme.getColorScheme().getForegroundColor());
			this.setText(theme.getDisplayName());
			this.currTheme = theme;
			return this;
		}

		@Override
		public void paint(Graphics g) {
			int width = this.getWidth();
			int height = this.getHeight();
			SubstanceImageCreator.paintRectangularBackground(g, 0, 0, width,
					height, this.currTheme.getColorScheme(), 0.0f, false);
			super.paint(g);
		}
	}

	/**
	 * Creates a panel with theme selector combobox.
	 */
	public ThemesPanel() {
		this.setLayout(new FlowLayout());
		Vector<SubstanceTheme> themeVector = new Vector<SubstanceTheme>();

		if (UIManager.getLookAndFeel() instanceof SubstanceLookAndFeel) {
			Map<String, ThemeInfo> allThemes = SubstanceLookAndFeel
					.getAllThemes();
			for (Map.Entry<String, ThemeInfo> themeEntry : allThemes.entrySet()) {
				themeVector.add(SubstanceTheme.createInstance(themeEntry
						.getValue()));
			}
			JComboBox themeCombo = new JComboBox(themeVector);
			themeCombo.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent evt) {
					// Get the affected item
					final Object item = evt.getItem();

					if (evt.getStateChange() == ItemEvent.SELECTED) {
						SwingUtilities.invokeLater(new Runnable() {
							public void run() {
								try {
									SubstanceLookAndFeel
											.setCurrentTheme((SubstanceTheme) item);
									// UIManager
									// .setLookAndFeel(new
									// SubstanceLookAndFeel());
									for (Frame frame : Frame.getFrames()) {
										SwingUtilities
												.updateComponentTreeUI(frame);
									}
								} catch (Exception exc) {
								}
							};
						});
					}
				}
			});
			themeCombo.setRenderer(new ThemeComboRenderer());

			this.add(themeCombo);
		}
	}
}
