package test.contrib;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

import org.jvnet.substance.SubstanceLookAndFeel;

public class FullScreenMode extends JFrame {

	public static final int EXCLUSIVE = 0;

	public static final int FULL = 1;

	public static final int DECORATED = 2;

	private int mode = 0;

	public FullScreenMode(String title) throws Exception {
		super(title);
		UIManager.setLookAndFeel(new SubstanceLookAndFeel());
		setMode(EXCLUSIVE);
		setDefaultCloseOperation(EXIT_ON_CLOSE);
		KeyStroke escapeKeyStroke = KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0, false);
		Action escapeAction = new AbstractAction() {

			public void actionPerformed(ActionEvent e) {
				if (mode == EXCLUSIVE) {
					setMode(DECORATED);
				}
			}
		};
		getRootPane().getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(escapeKeyStroke, "ESCAPE");
		getRootPane().getActionMap().put("ESCAPE", escapeAction);
	}

	public synchronized void setMode(int mode) {
		boolean isDisp = isDisplayable();
		if (isDisp) dispose();
		this.mode = mode;
		GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
		switch (mode) {
			case EXCLUSIVE:
				if (device.isFullScreenSupported()) {
					setUndecorated(true);
					setResizable(false);
					device.setFullScreenWindow(this);
					break;
				}
			case FULL:
				setUndecorated(true);
				setResizable(false);
				setLocation(0, 0);
				setSize(Toolkit.getDefaultToolkit().getScreenSize());
				break;
			case DECORATED:
				device.setFullScreenWindow(null);
				setUndecorated(false);
				setResizable(true);
		}
		if (isDisp) setVisible(true);
	}

	public static void main(String[] args) throws Exception {
		final FullScreenMode test = new FullScreenMode("Test frame");
		JDesktopPane pane = new JDesktopPane();
		JInternalFrame frame = new JInternalFrame("Test internal",true,true,true,true);
		KeyStroke escapeKeyStroke = KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0, false);
		Action escapeAction = new AbstractAction() {

			public void actionPerformed(ActionEvent e) {
					test.setMode(DECORATED);
			}
		};
		frame.getRootPane().getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(escapeKeyStroke, "ESCAPE");
		frame.getRootPane().getActionMap().put("ESCAPE", escapeAction);


		frame.setLocation(0, 0);
		frame.setSize(400, 400);
		pane.add(frame);
		test.setContentPane(pane);
		test.setVisible(true);
		frame.setVisible(true);
	}


}

/***

Exception in thread "AWT-EventQueue-0" java.lang.NullPointerException
	at javax.swing.plaf.basic.BasicGraphicsUtils.isLeftToRight(BasicGraphicsUtils.java:287)
	at javax.swing.plaf.basic.BasicMenuItemUI.layoutMenuItem(BasicMenuItemUI.java:807)
	at javax.swing.plaf.basic.BasicMenuItemUI.getPreferredMenuItemSize(BasicMenuItemUI.java:378)
	at org.jvnet.substance.SubstanceMenuUI.getPreferredMenuItemSize(SubstanceMenuUI.java:409)
	at javax.swing.plaf.basic.BasicMenuItemUI.getPreferredSize(BasicMenuItemUI.java:310)
	at javax.swing.JComponent.getPreferredSize(JComponent.java:1582)
	at javax.swing.BoxLayout.checkRequests(BoxLayout.java:434)
	at javax.swing.BoxLayout.layoutContainer(BoxLayout.java:375)
	at java.awt.Container.layout(Container.java:1401)
	at java.awt.Container.doLayout(Container.java:1390)
	at java.awt.Container.validateTree(Container.java:1473)
	at java.awt.Container.validateTree(Container.java:1480)
	at java.awt.Container.validateTree(Container.java:1480)
	at java.awt.Container.validateTree(Container.java:1480)
	at java.awt.Container.validateTree(Container.java:1480)
	at java.awt.Container.validateTree(Container.java:1480)
	at java.awt.Container.validateTree(Container.java:1480)
	at java.awt.Container.validate(Container.java:1448)
	at java.awt.Window.show(Window.java:507)
	at java.awt.Component.show(Component.java:1300)
	at java.awt.Component.setVisible(Component.java:1253)
	at Test.setMode(Test.java:70)
	at Test$1.actionPerformed(Test.java:38)
	at javax.swing.SwingUtilities.notifyAction(SwingUtilities.java:1571)
	at javax.swing.JComponent.processKeyBinding(JComponent.java:2730)
	at javax.swing.KeyboardManager.fireBinding(KeyboardManager.java:255)
	at javax.swing.KeyboardManager.fireKeyboardAction(KeyboardManager.java:204)
	at javax.swing.JComponent.processKeyBindingsForAllComponents(JComponent.java:2807)
	at javax.swing.SwingUtilities.processKeyBindings(SwingUtilities.java:1488)
	at javax.swing.UIManager$2.postProcessKeyEvent(UIManager.java:1283)
	at java.awt.DefaultKeyboardFocusManager.dispatchKeyEvent(DefaultKeyboardFocusManager.java:678)
	at java.awt.DefaultKeyboardFocusManager.preDispatchKeyEvent(DefaultKeyboardFocusManager.java:916)
	at java.awt.DefaultKeyboardFocusManager.typeAheadAssertions(DefaultKeyboardFocusManager.java:794)
	at java.awt.DefaultKeyboardFocusManager.dispatchEvent(DefaultKeyboardFocusManager.java:632)
	at java.awt.Component.dispatchEventImpl(Component.java:3841)
	at java.awt.Container.dispatchEventImpl(Container.java:2024)
	at java.awt.Window.dispatchEventImpl(Window.java:1766)
	at java.awt.Component.dispatchEvent(Component.java:3803)
	at java.awt.EventQueue.dispatchEvent(EventQueue.java:463)
	at java.awt.EventDispatchThread.pumpOneEventForHierarchy(EventDispatchThread.java:234)
	at java.awt.EventDispatchThread.pumpEventsForHierarchy(EventDispatchThread.java:163)
	at java.awt.EventDispatchThread.pumpEvents(EventDispatchThread.java:157)
	at java.awt.EventDispatchThread.pumpEvents(EventDispatchThread.java:149)
	at java.awt.EventDispatchThread.run(EventDispatchThread.java:110)
Exception in thread "AWT-EventQueue-0" java.lang.NullPointerException
	at javax.swing.SizeRequirements.calculateTiledPositions(SizeRequirements.java:294)
	at javax.swing.BoxLayout.layoutContainer(BoxLayout.java:378)
	at java.awt.Container.layout(Container.java:1401)
	at java.awt.Container.doLayout(Container.java:1390)
	at java.awt.Container.validateTree(Container.java:1473)
	at java.awt.Container.validateTree(Container.java:1480)
	at java.awt.Container.validateTree(Container.java:1480)
	at java.awt.Container.validate(Container.java:1448)
	at javax.swing.plaf.basic.BasicInternalFrameUI$Handler.componentResized(BasicInternalFrameUI.java:1169)
	at java.awt.Component.processComponentEvent(Component.java:5314)
	at java.awt.Component.processEvent(Component.java:5268)
	at java.awt.Container.processEvent(Container.java:1966)
	at java.awt.Component.dispatchEventImpl(Component.java:3955)
	at java.awt.Container.dispatchEventImpl(Container.java:2024)
	at java.awt.Component.dispatchEvent(Component.java:3803)
	at java.awt.EventQueue.dispatchEvent(EventQueue.java:463)
	at java.awt.EventDispatchThread.pumpOneEventForHierarchy(EventDispatchThread.java:234)
	at java.awt.EventDispatchThread.pumpEventsForHierarchy(EventDispatchThread.java:163)
	at java.awt.EventDispatchThread.pumpEvents(EventDispatchThread.java:157)
	at java.awt.EventDispatchThread.pumpEvents(EventDispatchThread.java:149)
	at java.awt.EventDispatchThread.run(EventDispatchThread.java:110)

******/
