package test.contrib;
import java.awt.Dimension;
import java.beans.PropertyVetoException;

import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

import org.jvnet.substance.SubstanceLookAndFeel;

public class InternalFrameBug extends JFrame {

    public class ExampleFrame extends JInternalFrame {
        public ExampleFrame() {
            setIconifiable(true);
            setSize(400, 200);
        }
    }

    public InternalFrameBug() {

        JDesktopPane desktop = new JDesktopPane();

        getContentPane().add(desktop, "Center");

        setDefaultCloseOperation(EXIT_ON_CLOSE);

        ExampleFrame frame = new ExampleFrame();

        desktop.add(frame);
        frame.setVisible(true);
        desktop.moveToFront(frame);
        try {
            frame.setSelected(true);
        } catch (PropertyVetoException ex) {
            frame.toBack();
        }

        setSize(new Dimension(600, 400));
    }

    public static void main(String[] args) {

        try {
            UIManager.setLookAndFeel(new SubstanceLookAndFeel());
        } catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }

        InternalFrameBug main = new InternalFrameBug();
        main.setVisible(true);
    }

}
