package test.contrib;

import java.awt.BorderLayout;

import javax.swing.*;

public class LafPreviewPanel {
	JPanel preview = null;
	JList listLooks = null;
	private JFrame frame;

	public LafPreviewPanel() throws Exception {
		createUI();
	}

	private void createUI() throws Exception {
		UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());

		frame = new JFrame();
		JMenuBar bar = new JMenuBar();
		JMenu menu = new JMenu("File");
		bar.add(menu);
		frame.setJMenuBar(bar);
		frame.setSize(600, 200);
		frame.setTitle("LAF Changer");
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setLayout(new BorderLayout());

		listLooks = new JList();

		listLooks.setModel(new javax.swing.AbstractListModel() {
			String[] strings = { "javax.swing.plaf.metal.MetalLookAndFeel",
					"com.sun.java.swing.plaf.windows.WindowsLookAndFeel",
					"com.sun.java.swing.plaf.motif.MotifLookAndFeel",
					"org.jvnet.substance.SubstanceLookAndFeel" };

			public int getSize() {
				return strings.length;
			}

			public Object getElementAt(int i) {
				return strings[i];
			}
		});
		listLooks
				.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
					public void valueChanged(
							javax.swing.event.ListSelectionEvent evt) {
						listLooksValueChanged(evt);
					}
				});

		preview = new JPanel();
		preview.add(new JButton("Hello Button"));
		preview.add(new JLabel("Hello Label"));
		preview.add(new JTextField(25));

		frame.add(listLooks, BorderLayout.NORTH);
		frame.add(preview, BorderLayout.SOUTH);

		frame.setVisible(true);
	}

	private void listLooksValueChanged(javax.swing.event.ListSelectionEvent evt) {
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				try {

					UIManager.setLookAndFeel(listLooks.getSelectedValue()
							.toString());
					SwingUtilities.updateComponentTreeUI(frame);

					// comment out the following line to see how
					// the rendering of components does not complete
					// for both Metal & Substance LAF

					// UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	public static void main(String[] args) {
		try {
			LafPreviewPanel main = new LafPreviewPanel();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}