package test.contrib;

import java.awt.event.*;
import java.util.*;

import javax.swing.*;

import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.theme.ThemeInfo;
import org.jvnet.substance.watermark.WatermarkInfo;

public class MenuBarTest2 extends JFrame implements ActionListener,
		ItemListener {
	// ******** A L L M E N U S T U F F ********
	Map<String, ThemeInfo> themes = null;
	Map<String, WatermarkInfo> wms = null;
	JPanel jMenuPanel = null;
	JMenuBar menuBar = new JMenuBar();

	JMenu mnuFile = new JMenu();
	JMenuItem fileMnuItemExit = new JMenuItem();

	JMenu mnuNewsGroups = new JMenu();
	JMenuItem ngMnuItemOpenSavedList = new JMenuItem();
	JMenuItem ngMnuItemSaveList = new JMenuItem();

	JMenu mnuOptions = new JMenu();
	JMenuItem optionMnuItemConfiguration = new JMenuItem();
	JMenu optionMnuItemColor = new JMenu();
	JMenu optionMnuItemBackground = new JMenu();
	Vector<JMenuItem> colorOptions = new Vector();
	Vector<JMenuItem> bgOptions = new Vector();

	JMenu mnuTools = new JMenu();
	JMenuItem toolMnuItemSplitFile = new JMenuItem();

	JMenu mnuHelp = new JMenu();
	JMenuItem helpMnuItemHelp = new JMenuItem();
	JMenuItem helpMnuItemAbout = new JMenuItem();
	JMenuItem helpMnuItemRegister = new JMenuItem();

	// ----------------------------------------------------------------------------
	//
	public MenuBarTest2() {
		super("My Frame");
		setSize(500, 300);
		setLocation(250, 250);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		createFrame();
	}

	// ----------------------------------------------------------------------------
	//
	public static void main(String[] args) throws Exception {
		UIManager.setLookAndFeel(new SubstanceLookAndFeel());
		MenuBarTest2 f = new MenuBarTest2();
		f.setVisible(true);
	}

	// ----------------------------------------------------------------------------
	//
	public void createFrame() {
		createMenu();
		setJMenuBar(menuBar);
		// this.pack();

		try {
			UIManager.setLookAndFeel(new SubstanceLookAndFeel());
			SubstanceLookAndFeel
					.setCurrentTheme("org.jvnet.substance.theme.SubstanceOliveTheme");
			updateComponents();
		} catch (Exception e) {
		}

	}

	public void updateComponents() {
		// SwingUtilities.updateComponentTreeUI(jMenuPanel);
		// SwingUtilities.updateComponentTreeUI(blankPanel);
	}

	// ----------------------------------------------------------------------------
	//
	public void createMenu() {
		mnuFile.setText("File");
		fileMnuItemExit.setText("Exit");
		fileMnuItemExit.addActionListener(new MenuAction());
		mnuFile.add(fileMnuItemExit);
		menuBar.add(mnuFile);

		mnuNewsGroups.setText("Edit");
		ngMnuItemOpenSavedList.setText("Open List");
		ngMnuItemSaveList.setText("Save List");
		mnuNewsGroups.add(ngMnuItemOpenSavedList);
		mnuNewsGroups.add(ngMnuItemSaveList);
		menuBar.add(mnuNewsGroups);

		mnuOptions.setText("Options");
		optionMnuItemConfiguration.setText("Configuration");
		optionMnuItemColor.setText("Change Color");
		optionMnuItemBackground.setText("Change Background");
		mnuOptions.add(optionMnuItemConfiguration);
		mnuOptions.add(optionMnuItemColor);
		mnuOptions.add(optionMnuItemBackground);

		// Call to populate what colors and backgrounds users can choose from
		getSkins();

		for (JMenuItem jmi : colorOptions) {
			optionMnuItemColor.add(jmi);
		}

		for (JMenuItem jmi : bgOptions) {
			optionMnuItemBackground.add(jmi);
		}

		menuBar.add(mnuOptions);

		mnuTools.setText("Tools");
		toolMnuItemSplitFile.setText("Split File");
		mnuTools.add(toolMnuItemSplitFile);
		menuBar.add(mnuTools);

		mnuHelp.setText("Help");
		helpMnuItemHelp.setText("Help");
		helpMnuItemAbout.setText("About");
		helpMnuItemRegister.setText("Register");
		mnuHelp.add(helpMnuItemHelp);
		mnuHelp.add(helpMnuItemAbout);
		mnuHelp.add(helpMnuItemRegister);
		menuBar.add(mnuHelp);
	}

	// ----------------------------------------------------------------------------
	//
	public void getSkins() {
		themes = new SubstanceLookAndFeel().getAllThemes();

		Iterator iter = themes.keySet().iterator();
		while (iter.hasNext()) {
			String nxtTheme = (String) iter.next();
			JMenuItem jmItem = new JMenuItem();
			jmItem.setText(nxtTheme);
			jmItem.addActionListener(new ChangeColorAction());
			colorOptions.add(jmItem);
		}

		wms = new SubstanceLookAndFeel().getAllWatermarks();

		iter = wms.keySet().iterator();

		while (iter.hasNext()) {
			String nxtWM = (String) iter.next();
			JMenuItem jmItem = new JMenuItem();

			if (nxtWM.equalsIgnoreCase("NULL"))
				nxtWM = "None";

			jmItem.setText(nxtWM);
			jmItem.addActionListener(new ChangeWMAction());
			bgOptions.add(jmItem);
		}
	}

	// ----------------------------------------------------------------------------
	//
	public void actionPerformed(ActionEvent e) {
	}

	// ----------------------------------------------------------------------------
	//  
	public void itemStateChanged(ItemEvent e) {
	}

	// ----------------------------------------------------------------------------
	//
	public class MenuAction extends AbstractAction {
		public MenuAction() {
		}

		// --------------------------------------------------------------------------
		public void actionPerformed(ActionEvent e) {
			JMenuItem source = (JMenuItem) (e.getSource());
			String clicked = source.getText().toUpperCase();

			if (clicked.equals("EXIT"))
				System.exit(0);

		}
	}

	// ----------------------------------------------------------------------------
	//
	public class ChangeColorAction extends AbstractAction {
		public ChangeColorAction() {
		}

		// --------------------------------------------------------------------------
		public void actionPerformed(ActionEvent e) {
			JMenuItem source = (JMenuItem) (e.getSource());
			String newTheme = themes.get(source.getText()).getClassName();

			try {
				SubstanceLookAndFeel.setCurrentTheme(newTheme);
				UIManager.setLookAndFeel(new SubstanceLookAndFeel());
				// UIManager.setLookAndFeel(newTheme);
			} catch (Exception ee) {
				System.out.println("Can't Change Color");
			} finally {
				updateComponents();
			}

		}
	}

	// ----------------------------------------------------------------------------
	//
	public class ChangeWMAction extends AbstractAction {
		public ChangeWMAction() {
		}

		// --------------------------------------------------------------------------
		public void actionPerformed(ActionEvent e) {
			JMenuItem source = (JMenuItem) (e.getSource());
			String newWM = source.getText();

			if (newWM.equalsIgnoreCase("None")) {
				newWM = wms.get("Null").getClassName();
			} else {
				try {
					newWM = wms.get(newWM).getClassName();
					SubstanceLookAndFeel.setCurrentWatermark(newWM);
					// UIManager.setLookAndFeel(new SubstanceLookAndFeel());
					// UIManager.setLookAndFeel(SubstanceLookAndFeel.getCurrentThemeName());
				} catch (Exception ee) {
					System.out.println("Can't Change BG");
				} finally {
					updateComponents();
				}
			}
		}
	}

	public void displayResult(String result) {
		System.out.println(result);
	}
}
