package test.contrib;

import java.awt.*;

import javax.swing.*;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

import org.jvnet.substance.SubstanceLookAndFeel;

public class TreeWithTableRenderer extends JFrame {
	private JTree tree;

	public class RepositoryTableTreeCellRenderer extends JPanel implements
			TreeCellRenderer {
		private JTable table;

		public RepositoryTableTreeCellRenderer() {
			super(new BorderLayout());
			this.table = new JTable();
			JScrollPane scrollPane = new JScrollPane(table);
			this.add(scrollPane);
		}

		public Component getTreeCellRendererComponent(JTree tree, Object value,
				boolean selected, boolean expanded, boolean leaf, int row,
				boolean hasFocus) {
			final String v = (String) ((DefaultMutableTreeNode) value)
					.getUserObject();
			this.table.setModel(new DefaultTableModel() {
				@Override
				public int getRowCount() {
					return 2;
				}

				@Override
				public int getColumnCount() {
					return 2;
				}

				@Override
				public Object getValueAt(int row, int column) {
					return v + ":" + row + ":" + column;
				}
			});

			return this;
		}
	}

	public TreeWithTableRenderer() {
		this.setLayout(new BorderLayout());

		DefaultMutableTreeNode root = new DefaultMutableTreeNode("root");
		DefaultMutableTreeNode son1 = new DefaultMutableTreeNode("son1");
		DefaultMutableTreeNode son2 = new DefaultMutableTreeNode("son2");
		DefaultMutableTreeNode son3 = new DefaultMutableTreeNode("son3");
		DefaultMutableTreeNode gson11 = new DefaultMutableTreeNode("gson11");
		DefaultMutableTreeNode gson12 = new DefaultMutableTreeNode("gson12");
		DefaultMutableTreeNode gson21 = new DefaultMutableTreeNode("gson21");
		DefaultMutableTreeNode gson22 = new DefaultMutableTreeNode("gson22");
		DefaultMutableTreeNode gson31 = new DefaultMutableTreeNode("gson31");
		DefaultMutableTreeNode gson32 = new DefaultMutableTreeNode("gson32");
		DefaultMutableTreeNode ggson111 = new DefaultMutableTreeNode("ggson11");
		DefaultMutableTreeNode ggson112 = new DefaultMutableTreeNode("ggson11");
		DefaultMutableTreeNode ggson113 = new DefaultMutableTreeNode("ggson11");

		gson11.add(ggson111);
		gson11.add(ggson112);
		gson11.add(ggson113);
		son1.add(gson11);
		son1.add(gson12);
		son2.add(gson21);
		son2.add(gson22);
		son3.add(gson31);
		son3.add(gson32);
		root.add(son1);
		root.add(son2);
		root.add(son3);

		this.tree = new JTree(root);
		this.tree.setCellRenderer(new RepositoryTableTreeCellRenderer());
		JScrollPane jsp = new JScrollPane(this.tree);
		this.add(jsp, BorderLayout.CENTER);

		this.setSize(500, 300);
		this.setLocationRelativeTo(null);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}

	public static void main(String[] args) throws Exception {
//		UIManager.setLookAndFeel(new SubstanceLookAndFeel());
		new TreeWithTableRenderer().setVisible(true);
	}
}