package test.contrib.greg;

import java.awt.Dimension;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.theme.SubstanceOliveTheme;

public class SubstanceFullRepaintTest extends JFrame {
   private static final long serialVersionUID = 1L;
   private JScrollPane _scrollPanel;
   private MyComponent _component;
   
   private static boolean _useSubstance = false;

   public SubstanceFullRepaintTest(int width_p, int height_p) throws Exception {

      setSize(width_p, height_p);

      _component = new MyComponent();
      _component.setOpaque(true);
      _component.setPreferredSize(new Dimension(width_p, 2 * height_p));
      //_component.putClientProperty(SubstanceLookAndFeel.WATERMARK_IGNORE, Boolean.TRUE);

      _scrollPanel = new JScrollPane(_component);
      _scrollPanel.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
      //_scrollPanel.putClientProperty(SubstanceLookAndFeel.WATERMARK_IGNORE, Boolean.TRUE);

      DateMenu menu = new DateMenu();
      //menu.putClientProperty(SubstanceLookAndFeel.WATERMARK_IGNORE, Boolean.TRUE);
      setJMenuBar(menu);

      getContentPane().add(_scrollPanel);

   }

   public static void main(String[] args_p) {
      // Schedule a job for the event-dispatching thread:
      // creating and showing this application's GUI.
      javax.swing.SwingUtilities.invokeLater(new Runnable() {
         public void run() {
            createAndShowGUI();
         }
      });
   }

   public static void createAndShowGUI() {
      try {
         SubstanceFullRepaintTest frame = new SubstanceFullRepaintTest(1280, 960);
         frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
         
         // Change true into false to get no double repaint
         if (_useSubstance) {
            try {
               new SubstanceLookAndFeel();
               SubstanceLookAndFeel.setCurrentTheme(new SubstanceOliveTheme());
               UIManager.setLookAndFeel(new SubstanceLookAndFeel());
            } catch (UnsupportedLookAndFeelException e) {
               e.printStackTrace();
            }
            SwingUtilities.updateComponentTreeUI(frame);
         }
         
         frame.setVisible(true);
      } catch (Exception e) {

      }
   }

}
