/*
 * Copyright (c) 2005-2008 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package org.jvnet.substance.painter.highlight;

import java.awt.*;
import java.util.Set;

import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.api.SubstanceConstants.Side;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

/**
 * Utilities for painting higlight backgrounds.
 * 
 * @author Kirill Grouchnikov
 */
public class SubstanceHighlightUtils {
	/**
	 * Updates the specified component with the background that matches the
	 * provided parameters.
	 * 
	 * @param g
	 *            Graphic context.
	 * @param c
	 *            Component.
	 * @param rect
	 *            Rectangle to highlight.
	 * @param borderAlpha
	 *            Border alpha.
	 * @param openSides
	 *            The sides specified in this set will not be painted. Can be
	 *            <code>null</code> or empty.
	 * @param colorScheme1
	 *            The first color scheme.
	 * @param colorScheme2
	 *            The second color scheme.
	 * @param cyclePos
	 *            Cycle position. Is used for rollover and pulsation effects.
	 *            Must be in 0..10 range.
	 */
	public static void paintHighlight(Graphics g, Component c, Rectangle rect,
			float borderAlpha, Set<Side> openSides,
			SubstanceColorScheme colorScheme1,
			SubstanceColorScheme colorScheme2, float cyclePos) {
		// fix for bug 65
		if ((rect.width <= 0) || (rect.height <= 0))
			return;

		SubstanceHighlightPainter highlightPainter = SubstanceCoreUtilities
				.getSkin(c).getHighlightPainter();
		Graphics2D g2d = (Graphics2D) g.create(rect.x, rect.y, rect.width,
				rect.height);

		highlightPainter.paintHighlight(g2d, c, rect.width, rect.height,
				borderAlpha, openSides, colorScheme1, colorScheme2, cyclePos);
		g2d.dispose();
	}
}
